package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  FileType,
  FileName,
  Value,
  AttributeKey,
  OTAUpdateFileVersion
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class OTAUpdateFile(
    fileName: Optional[FileName] = Optional.Absent,
    fileType: Optional[FileType] = Optional.Absent,
    fileVersion: Optional[OTAUpdateFileVersion] = Optional.Absent,
    fileLocation: Optional[zio.aws.iot.model.FileLocation] = Optional.Absent,
    codeSigning: Optional[zio.aws.iot.model.CodeSigning] = Optional.Absent,
    attributes: Optional[Map[AttributeKey, Value]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.OTAUpdateFile = {
    import OTAUpdateFile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.OTAUpdateFile
      .builder()
      .optionallyWith(
        fileName.map(value => FileName.unwrap(value): java.lang.String)
      )(_.fileName)
      .optionallyWith(fileType.map(value => FileType.unwrap(value): Integer))(
        _.fileType
      )
      .optionallyWith(
        fileVersion.map(value =>
          OTAUpdateFileVersion.unwrap(value): java.lang.String
        )
      )(_.fileVersion)
      .optionallyWith(fileLocation.map(value => value.buildAwsValue()))(
        _.fileLocation
      )
      .optionallyWith(codeSigning.map(value => value.buildAwsValue()))(
        _.codeSigning
      )
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeKey.unwrap(key): java.lang.String) -> (Value
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.OTAUpdateFile.ReadOnly =
    zio.aws.iot.model.OTAUpdateFile.wrap(buildAwsValue())
}
object OTAUpdateFile {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.OTAUpdateFile] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.OTAUpdateFile =
      zio.aws.iot.model.OTAUpdateFile(
        fileName.map(value => value),
        fileType.map(value => value),
        fileVersion.map(value => value),
        fileLocation.map(value => value.asEditable),
        codeSigning.map(value => value.asEditable),
        attributes.map(value => value)
      )
    def fileName: Optional[FileName]
    def fileType: Optional[FileType]
    def fileVersion: Optional[OTAUpdateFileVersion]
    def fileLocation: Optional[zio.aws.iot.model.FileLocation.ReadOnly]
    def codeSigning: Optional[zio.aws.iot.model.CodeSigning.ReadOnly]
    def attributes: Optional[Map[AttributeKey, Value]]
    def getFileName: ZIO[Any, AwsError, FileName] =
      AwsError.unwrapOptionField("fileName", fileName)
    def getFileType: ZIO[Any, AwsError, FileType] =
      AwsError.unwrapOptionField("fileType", fileType)
    def getFileVersion: ZIO[Any, AwsError, OTAUpdateFileVersion] =
      AwsError.unwrapOptionField("fileVersion", fileVersion)
    def getFileLocation
        : ZIO[Any, AwsError, zio.aws.iot.model.FileLocation.ReadOnly] =
      AwsError.unwrapOptionField("fileLocation", fileLocation)
    def getCodeSigning
        : ZIO[Any, AwsError, zio.aws.iot.model.CodeSigning.ReadOnly] =
      AwsError.unwrapOptionField("codeSigning", codeSigning)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeKey, Value]] =
      AwsError.unwrapOptionField("attributes", attributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.OTAUpdateFile
  ) extends zio.aws.iot.model.OTAUpdateFile.ReadOnly {
    override val fileName: Optional[FileName] = zio.aws.core.internal
      .optionalFromNullable(impl.fileName())
      .map(value => zio.aws.iot.model.primitives.FileName(value))
    override val fileType: Optional[FileType] = zio.aws.core.internal
      .optionalFromNullable(impl.fileType())
      .map(value => zio.aws.iot.model.primitives.FileType(value))
    override val fileVersion: Optional[OTAUpdateFileVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileVersion())
        .map(value => zio.aws.iot.model.primitives.OTAUpdateFileVersion(value))
    override val fileLocation
        : Optional[zio.aws.iot.model.FileLocation.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fileLocation())
        .map(value => zio.aws.iot.model.FileLocation.wrap(value))
    override val codeSigning: Optional[zio.aws.iot.model.CodeSigning.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.codeSigning())
        .map(value => zio.aws.iot.model.CodeSigning.wrap(value))
    override val attributes: Optional[Map[AttributeKey, Value]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives
                .AttributeKey(key) -> zio.aws.iot.model.primitives.Value(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.OTAUpdateFile
  ): zio.aws.iot.model.OTAUpdateFile.ReadOnly = new Wrapper(impl)
}
