package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait OTAUpdateStatus {
  def unwrap: software.amazon.awssdk.services.iot.model.OTAUpdateStatus
}
object OTAUpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.OTAUpdateStatus
  ): zio.aws.iot.model.OTAUpdateStatus = value match {
    case software.amazon.awssdk.services.iot.model.OTAUpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_PENDING =>
      val r = CREATE_PENDING
      r
    case software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_IN_PROGRESS =>
      val r = CREATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_COMPLETE =>
      val r = CREATE_COMPLETE
      r
    case software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.OTAUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.OTAUpdateStatus =
      software.amazon.awssdk.services.iot.model.OTAUpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATE_PENDING extends zio.aws.iot.model.OTAUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.OTAUpdateStatus =
      software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_PENDING
  }
  case object CREATE_IN_PROGRESS extends zio.aws.iot.model.OTAUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.OTAUpdateStatus =
      software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_IN_PROGRESS
  }
  case object CREATE_COMPLETE extends zio.aws.iot.model.OTAUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.OTAUpdateStatus =
      software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_COMPLETE
  }
  case object CREATE_FAILED extends zio.aws.iot.model.OTAUpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.OTAUpdateStatus =
      software.amazon.awssdk.services.iot.model.OTAUpdateStatus.CREATE_FAILED
  }
}
