package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  Message,
  DateType,
  CertificateId,
  CertificateArn,
  AwsAccountId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class OutgoingCertificate(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent,
    transferredTo: Optional[AwsAccountId] = Optional.Absent,
    transferDate: Optional[DateType] = Optional.Absent,
    transferMessage: Optional[Message] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.OutgoingCertificate = {
    import OutgoingCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.OutgoingCertificate
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .optionallyWith(
        transferredTo.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.transferredTo)
      .optionallyWith(
        transferDate.map(value => DateType.unwrap(value): Instant)
      )(_.transferDate)
      .optionallyWith(
        transferMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.transferMessage)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.OutgoingCertificate.ReadOnly =
    zio.aws.iot.model.OutgoingCertificate.wrap(buildAwsValue())
}
object OutgoingCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.OutgoingCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.OutgoingCertificate =
      zio.aws.iot.model.OutgoingCertificate(
        certificateArn.map(value => value),
        certificateId.map(value => value),
        transferredTo.map(value => value),
        transferDate.map(value => value),
        transferMessage.map(value => value),
        creationDate.map(value => value)
      )
    def certificateArn: Optional[CertificateArn]
    def certificateId: Optional[CertificateId]
    def transferredTo: Optional[AwsAccountId]
    def transferDate: Optional[DateType]
    def transferMessage: Optional[Message]
    def creationDate: Optional[DateType]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
    def getTransferredTo: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("transferredTo", transferredTo)
    def getTransferDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("transferDate", transferDate)
    def getTransferMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("transferMessage", transferMessage)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.OutgoingCertificate
  ) extends zio.aws.iot.model.OutgoingCertificate.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val transferredTo: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.transferredTo())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val transferDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.transferDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val transferMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.transferMessage())
      .map(value => zio.aws.iot.model.primitives.Message(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.OutgoingCertificate
  ): zio.aws.iot.model.OutgoingCertificate.ReadOnly = new Wrapper(impl)
}
