package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait PolicyTemplateName {
  def unwrap: software.amazon.awssdk.services.iot.model.PolicyTemplateName
}
object PolicyTemplateName {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.PolicyTemplateName
  ): zio.aws.iot.model.PolicyTemplateName = value match {
    case software.amazon.awssdk.services.iot.model.PolicyTemplateName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.PolicyTemplateName.BLANK_POLICY =>
      val r = BLANK_POLICY
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.PolicyTemplateName {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.PolicyTemplateName =
      software.amazon.awssdk.services.iot.model.PolicyTemplateName.UNKNOWN_TO_SDK_VERSION
  }
  case object BLANK_POLICY extends zio.aws.iot.model.PolicyTemplateName {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.PolicyTemplateName =
      software.amazon.awssdk.services.iot.model.PolicyTemplateName.BLANK_POLICY
  }
}
