package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  DateType,
  IsDefaultVersion,
  PolicyVersionId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class PolicyVersion(
    versionId: Optional[PolicyVersionId] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent,
    createDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PolicyVersion = {
    import PolicyVersion.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PolicyVersion
      .builder()
      .optionallyWith(
        versionId.map(value => PolicyVersionId.unwrap(value): java.lang.String)
      )(_.versionId)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .optionallyWith(createDate.map(value => DateType.unwrap(value): Instant))(
        _.createDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PolicyVersion.ReadOnly =
    zio.aws.iot.model.PolicyVersion.wrap(buildAwsValue())
}
object PolicyVersion {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.PolicyVersion] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PolicyVersion =
      zio.aws.iot.model.PolicyVersion(
        versionId.map(value => value),
        isDefaultVersion.map(value => value),
        createDate.map(value => value)
      )
    def versionId: Optional[PolicyVersionId]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def createDate: Optional[DateType]
    def getVersionId: ZIO[Any, AwsError, PolicyVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
    def getCreateDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createDate", createDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersion
  ) extends zio.aws.iot.model.PolicyVersion.ReadOnly {
    override val versionId: Optional[PolicyVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.iot.model.primitives.PolicyVersionId(value))
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
    override val createDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PolicyVersion
  ): zio.aws.iot.model.PolicyVersion.ReadOnly = new Wrapper(impl)
}
