package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait Protocol {
  def unwrap: software.amazon.awssdk.services.iot.model.Protocol
}
object Protocol {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.Protocol
  ): zio.aws.iot.model.Protocol = value match {
    case software.amazon.awssdk.services.iot.model.Protocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.Protocol.MQTT =>
      val r = MQTT
      r
    case software.amazon.awssdk.services.iot.model.Protocol.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.iot.model.Protocol =
      software.amazon.awssdk.services.iot.model.Protocol.UNKNOWN_TO_SDK_VERSION
  }
  case object MQTT extends zio.aws.iot.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.iot.model.Protocol =
      software.amazon.awssdk.services.iot.model.Protocol.MQTT
  }
  case object HTTP extends zio.aws.iot.model.Protocol {
    override def unwrap: software.amazon.awssdk.services.iot.model.Protocol =
      software.amazon.awssdk.services.iot.model.Protocol.HTTP
  }
}
