package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IsDefaultVersion,
  DateType,
  TemplateVersionId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ProvisioningTemplateVersionSummary(
    versionId: Optional[TemplateVersionId] = Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    isDefaultVersion: Optional[IsDefaultVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary = {
    import ProvisioningTemplateVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary
      .builder()
      .optionallyWith(
        versionId.map(value => TemplateVersionId.unwrap(value): Integer)
      )(_.versionId)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        isDefaultVersion.map(value =>
          IsDefaultVersion.unwrap(value): java.lang.Boolean
        )
      )(_.isDefaultVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly =
    zio.aws.iot.model.ProvisioningTemplateVersionSummary.wrap(buildAwsValue())
}
object ProvisioningTemplateVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ProvisioningTemplateVersionSummary =
      zio.aws.iot.model.ProvisioningTemplateVersionSummary(
        versionId.map(value => value),
        creationDate.map(value => value),
        isDefaultVersion.map(value => value)
      )
    def versionId: Optional[TemplateVersionId]
    def creationDate: Optional[DateType]
    def isDefaultVersion: Optional[IsDefaultVersion]
    def getVersionId: ZIO[Any, AwsError, TemplateVersionId] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getIsDefaultVersion: ZIO[Any, AwsError, IsDefaultVersion] =
      AwsError.unwrapOptionField("isDefaultVersion", isDefaultVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary
  ) extends zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly {
    override val versionId: Optional[TemplateVersionId] = zio.aws.core.internal
      .optionalFromNullable(impl.versionId())
      .map(value => zio.aws.iot.model.primitives.TemplateVersionId(value))
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val isDefaultVersion: Optional[IsDefaultVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isDefaultVersion())
        .map(value => zio.aws.iot.model.primitives.IsDefaultVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ProvisioningTemplateVersionSummary
  ): zio.aws.iot.model.ProvisioningTemplateVersionSummary.ReadOnly =
    new Wrapper(impl)
}
