package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.SnsTopicArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class PublishFindingToSnsParams(topicArn: SnsTopicArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.PublishFindingToSnsParams = {
    import PublishFindingToSnsParams.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.PublishFindingToSnsParams
      .builder()
      .topicArn(SnsTopicArn.unwrap(topicArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.PublishFindingToSnsParams.ReadOnly =
    zio.aws.iot.model.PublishFindingToSnsParams.wrap(buildAwsValue())
}
object PublishFindingToSnsParams {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.PublishFindingToSnsParams
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.PublishFindingToSnsParams =
      zio.aws.iot.model.PublishFindingToSnsParams(topicArn)
    def topicArn: SnsTopicArn
    def getTopicArn: ZIO[Any, Nothing, SnsTopicArn] = ZIO.succeed(topicArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.PublishFindingToSnsParams
  ) extends zio.aws.iot.model.PublishFindingToSnsParams.ReadOnly {
    override val topicArn: SnsTopicArn =
      zio.aws.iot.model.primitives.SnsTopicArn(impl.topicArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.PublishFindingToSnsParams
  ): zio.aws.iot.model.PublishFindingToSnsParams.ReadOnly = new Wrapper(impl)
}
