package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.NumberOfThings
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RateIncreaseCriteria(
    numberOfNotifiedThings: Optional[NumberOfThings] = Optional.Absent,
    numberOfSucceededThings: Optional[NumberOfThings] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RateIncreaseCriteria = {
    import RateIncreaseCriteria.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
      .builder()
      .optionallyWith(
        numberOfNotifiedThings.map(value =>
          NumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfNotifiedThings)
      .optionallyWith(
        numberOfSucceededThings.map(value =>
          NumberOfThings.unwrap(value): Integer
        )
      )(_.numberOfSucceededThings)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RateIncreaseCriteria.ReadOnly =
    zio.aws.iot.model.RateIncreaseCriteria.wrap(buildAwsValue())
}
object RateIncreaseCriteria {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RateIncreaseCriteria =
      zio.aws.iot.model.RateIncreaseCriteria(
        numberOfNotifiedThings.map(value => value),
        numberOfSucceededThings.map(value => value)
      )
    def numberOfNotifiedThings: Optional[NumberOfThings]
    def numberOfSucceededThings: Optional[NumberOfThings]
    def getNumberOfNotifiedThings: ZIO[Any, AwsError, NumberOfThings] = AwsError
      .unwrapOptionField("numberOfNotifiedThings", numberOfNotifiedThings)
    def getNumberOfSucceededThings: ZIO[Any, AwsError, NumberOfThings] =
      AwsError.unwrapOptionField(
        "numberOfSucceededThings",
        numberOfSucceededThings
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
  ) extends zio.aws.iot.model.RateIncreaseCriteria.ReadOnly {
    override val numberOfNotifiedThings: Optional[NumberOfThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfNotifiedThings())
        .map(value => zio.aws.iot.model.primitives.NumberOfThings(value))
    override val numberOfSucceededThings: Optional[NumberOfThings] =
      zio.aws.core.internal
        .optionalFromNullable(impl.numberOfSucceededThings())
        .map(value => zio.aws.iot.model.primitives.NumberOfThings(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RateIncreaseCriteria
  ): zio.aws.iot.model.RateIncreaseCriteria.ReadOnly = new Wrapper(impl)
}
