package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{CertificateId, CertificateArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterCaCertificateResponse(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    certificateId: Optional[CertificateId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse = {
    import RegisterCaCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        certificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.certificateId)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly =
    zio.aws.iot.model.RegisterCaCertificateResponse.wrap(buildAwsValue())
}
object RegisterCaCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterCaCertificateResponse =
      zio.aws.iot.model.RegisterCaCertificateResponse(
        certificateArn.map(value => value),
        certificateId.map(value => value)
      )
    def certificateArn: Optional[CertificateArn]
    def certificateId: Optional[CertificateId]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("certificateId", certificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse
  ) extends zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val certificateId: Optional[CertificateId] = zio.aws.core.internal
      .optionalFromNullable(impl.certificateId())
      .map(value => zio.aws.iot.model.primitives.CertificateId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterCaCertificateResponse
  ): zio.aws.iot.model.RegisterCaCertificateResponse.ReadOnly = new Wrapper(
    impl
  )
}
