package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.CertificatePem
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterCertificateWithoutCaRequest(
    certificatePem: CertificatePem,
    status: Optional[zio.aws.iot.model.CertificateStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest = {
    import RegisterCertificateWithoutCaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest
      .builder()
      .certificatePem(CertificatePem.unwrap(certificatePem): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.RegisterCertificateWithoutCaRequest.ReadOnly =
    zio.aws.iot.model.RegisterCertificateWithoutCaRequest.wrap(buildAwsValue())
}
object RegisterCertificateWithoutCaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterCertificateWithoutCaRequest =
      zio.aws.iot.model.RegisterCertificateWithoutCaRequest(
        certificatePem,
        status.map(value => value)
      )
    def certificatePem: CertificatePem
    def status: Optional[zio.aws.iot.model.CertificateStatus]
    def getCertificatePem: ZIO[Any, Nothing, CertificatePem] =
      ZIO.succeed(certificatePem)
    def getStatus: ZIO[Any, AwsError, zio.aws.iot.model.CertificateStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest
  ) extends zio.aws.iot.model.RegisterCertificateWithoutCaRequest.ReadOnly {
    override val certificatePem: CertificatePem =
      zio.aws.iot.model.primitives.CertificatePem(impl.certificatePem())
    override val status: Optional[zio.aws.iot.model.CertificateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.iot.model.CertificateStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterCertificateWithoutCaRequest
  ): zio.aws.iot.model.RegisterCertificateWithoutCaRequest.ReadOnly =
    new Wrapper(impl)
}
