package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ResourceArn,
  ResourceLogicalId,
  CertificatePem
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RegisterThingResponse(
    certificatePem: Optional[CertificatePem] = Optional.Absent,
    resourceArns: Optional[Map[ResourceLogicalId, ResourceArn]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RegisterThingResponse = {
    import RegisterThingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RegisterThingResponse
      .builder()
      .optionallyWith(
        certificatePem.map(value =>
          CertificatePem.unwrap(value): java.lang.String
        )
      )(_.certificatePem)
      .optionallyWith(
        resourceArns.map(value =>
          value
            .map({ case (key, value) =>
              (ResourceLogicalId.unwrap(key): java.lang.String) -> (ResourceArn
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.resourceArns)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RegisterThingResponse.ReadOnly =
    zio.aws.iot.model.RegisterThingResponse.wrap(buildAwsValue())
}
object RegisterThingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RegisterThingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RegisterThingResponse =
      zio.aws.iot.model.RegisterThingResponse(
        certificatePem.map(value => value),
        resourceArns.map(value => value)
      )
    def certificatePem: Optional[CertificatePem]
    def resourceArns: Optional[Map[ResourceLogicalId, ResourceArn]]
    def getCertificatePem: ZIO[Any, AwsError, CertificatePem] =
      AwsError.unwrapOptionField("certificatePem", certificatePem)
    def getResourceArns
        : ZIO[Any, AwsError, Map[ResourceLogicalId, ResourceArn]] =
      AwsError.unwrapOptionField("resourceArns", resourceArns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RegisterThingResponse
  ) extends zio.aws.iot.model.RegisterThingResponse.ReadOnly {
    override val certificatePem: Optional[CertificatePem] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePem())
        .map(value => zio.aws.iot.model.primitives.CertificatePem(value))
    override val resourceArns: Optional[Map[ResourceLogicalId, ResourceArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArns())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.ResourceLogicalId(
                key
              ) -> zio.aws.iot.model.primitives.ResourceArn(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RegisterThingResponse
  ): zio.aws.iot.model.RegisterThingResponse.ReadOnly = new Wrapper(impl)
}
