package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait ReportType {
  def unwrap: software.amazon.awssdk.services.iot.model.ReportType
}
object ReportType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ReportType
  ): zio.aws.iot.model.ReportType = value match {
    case software.amazon.awssdk.services.iot.model.ReportType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ReportType.ERRORS =>
      val r = ERRORS
      r
    case software.amazon.awssdk.services.iot.model.ReportType.RESULTS =>
      val r = RESULTS
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ReportType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ReportType =
      software.amazon.awssdk.services.iot.model.ReportType.UNKNOWN_TO_SDK_VERSION
  }
  case object ERRORS extends zio.aws.iot.model.ReportType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ReportType =
      software.amazon.awssdk.services.iot.model.ReportType.ERRORS
  }
  case object RESULTS extends zio.aws.iot.model.ReportType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ReportType =
      software.amazon.awssdk.services.iot.model.ReportType.RESULTS
  }
}
