package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  RoleAliasArn,
  RoleArn,
  CertificateId,
  ClientId,
  CognitoIdentityPoolId,
  AwsAccountId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ResourceIdentifier(
    deviceCertificateId: Optional[CertificateId] = Optional.Absent,
    caCertificateId: Optional[CertificateId] = Optional.Absent,
    cognitoIdentityPoolId: Optional[CognitoIdentityPoolId] = Optional.Absent,
    clientId: Optional[ClientId] = Optional.Absent,
    policyVersionIdentifier: Optional[
      zio.aws.iot.model.PolicyVersionIdentifier
    ] = Optional.Absent,
    account: Optional[AwsAccountId] = Optional.Absent,
    iamRoleArn: Optional[RoleArn] = Optional.Absent,
    roleAliasArn: Optional[RoleAliasArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ResourceIdentifier = {
    import ResourceIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ResourceIdentifier
      .builder()
      .optionallyWith(
        deviceCertificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.deviceCertificateId)
      .optionallyWith(
        caCertificateId.map(value =>
          CertificateId.unwrap(value): java.lang.String
        )
      )(_.caCertificateId)
      .optionallyWith(
        cognitoIdentityPoolId.map(value =>
          CognitoIdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.cognitoIdentityPoolId)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        policyVersionIdentifier.map(value => value.buildAwsValue())
      )(_.policyVersionIdentifier)
      .optionallyWith(
        account.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.account)
      .optionallyWith(
        iamRoleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .optionallyWith(
        roleAliasArn.map(value => RoleAliasArn.unwrap(value): java.lang.String)
      )(_.roleAliasArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ResourceIdentifier.ReadOnly =
    zio.aws.iot.model.ResourceIdentifier.wrap(buildAwsValue())
}
object ResourceIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ResourceIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ResourceIdentifier =
      zio.aws.iot.model.ResourceIdentifier(
        deviceCertificateId.map(value => value),
        caCertificateId.map(value => value),
        cognitoIdentityPoolId.map(value => value),
        clientId.map(value => value),
        policyVersionIdentifier.map(value => value.asEditable),
        account.map(value => value),
        iamRoleArn.map(value => value),
        roleAliasArn.map(value => value)
      )
    def deviceCertificateId: Optional[CertificateId]
    def caCertificateId: Optional[CertificateId]
    def cognitoIdentityPoolId: Optional[CognitoIdentityPoolId]
    def clientId: Optional[ClientId]
    def policyVersionIdentifier
        : Optional[zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly]
    def account: Optional[AwsAccountId]
    def iamRoleArn: Optional[RoleArn]
    def roleAliasArn: Optional[RoleAliasArn]
    def getDeviceCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("deviceCertificateId", deviceCertificateId)
    def getCaCertificateId: ZIO[Any, AwsError, CertificateId] =
      AwsError.unwrapOptionField("caCertificateId", caCertificateId)
    def getCognitoIdentityPoolId: ZIO[Any, AwsError, CognitoIdentityPoolId] =
      AwsError.unwrapOptionField("cognitoIdentityPoolId", cognitoIdentityPoolId)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getPolicyVersionIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "policyVersionIdentifier",
      policyVersionIdentifier
    )
    def getAccount: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("account", account)
    def getIamRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getRoleAliasArn: ZIO[Any, AwsError, RoleAliasArn] =
      AwsError.unwrapOptionField("roleAliasArn", roleAliasArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ResourceIdentifier
  ) extends zio.aws.iot.model.ResourceIdentifier.ReadOnly {
    override val deviceCertificateId: Optional[CertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceCertificateId())
        .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val caCertificateId: Optional[CertificateId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.caCertificateId())
        .map(value => zio.aws.iot.model.primitives.CertificateId(value))
    override val cognitoIdentityPoolId: Optional[CognitoIdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoIdentityPoolId())
        .map(value => zio.aws.iot.model.primitives.CognitoIdentityPoolId(value))
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.iot.model.primitives.ClientId(value))
    override val policyVersionIdentifier
        : Optional[zio.aws.iot.model.PolicyVersionIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyVersionIdentifier())
        .map(value => zio.aws.iot.model.PolicyVersionIdentifier.wrap(value))
    override val account: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.account())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val iamRoleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val roleAliasArn: Optional[RoleAliasArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleAliasArn())
      .map(value => zio.aws.iot.model.primitives.RoleAliasArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ResourceIdentifier
  ): zio.aws.iot.model.ResourceIdentifier.ReadOnly = new Wrapper(impl)
}
