package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait RetryableFailureType {
  def unwrap: software.amazon.awssdk.services.iot.model.RetryableFailureType
}
object RetryableFailureType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.RetryableFailureType
  ): zio.aws.iot.model.RetryableFailureType = value match {
    case software.amazon.awssdk.services.iot.model.RetryableFailureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.RetryableFailureType.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.iot.model.RetryableFailureType.TIMED_OUT =>
      val r = TIMED_OUT
      r
    case software.amazon.awssdk.services.iot.model.RetryableFailureType.ALL =>
      val r = ALL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.iot.model.RetryableFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.RetryableFailureType =
      software.amazon.awssdk.services.iot.model.RetryableFailureType.UNKNOWN_TO_SDK_VERSION
  }
  case object FAILED extends zio.aws.iot.model.RetryableFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.RetryableFailureType =
      software.amazon.awssdk.services.iot.model.RetryableFailureType.FAILED
  }
  case object TIMED_OUT extends zio.aws.iot.model.RetryableFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.RetryableFailureType =
      software.amazon.awssdk.services.iot.model.RetryableFailureType.TIMED_OUT
  }
  case object ALL extends zio.aws.iot.model.RetryableFailureType {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.RetryableFailureType =
      software.amazon.awssdk.services.iot.model.RetryableFailureType.ALL
  }
}
