package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RoleAliasArn,
  RoleAlias,
  RoleArn,
  DateType,
  CredentialDurationSeconds,
  AwsAccountId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RoleAliasDescription(
    roleAlias: Optional[RoleAlias] = Optional.Absent,
    roleAliasArn: Optional[RoleAliasArn] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent,
    owner: Optional[AwsAccountId] = Optional.Absent,
    credentialDurationSeconds: Optional[CredentialDurationSeconds] =
      Optional.Absent,
    creationDate: Optional[DateType] = Optional.Absent,
    lastModifiedDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.RoleAliasDescription = {
    import RoleAliasDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.RoleAliasDescription
      .builder()
      .optionallyWith(
        roleAlias.map(value => RoleAlias.unwrap(value): java.lang.String)
      )(_.roleAlias)
      .optionallyWith(
        roleAliasArn.map(value => RoleAliasArn.unwrap(value): java.lang.String)
      )(_.roleAliasArn)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        owner.map(value => AwsAccountId.unwrap(value): java.lang.String)
      )(_.owner)
      .optionallyWith(
        credentialDurationSeconds.map(value =>
          CredentialDurationSeconds.unwrap(value): Integer
        )
      )(_.credentialDurationSeconds)
      .optionallyWith(
        creationDate.map(value => DateType.unwrap(value): Instant)
      )(_.creationDate)
      .optionallyWith(
        lastModifiedDate.map(value => DateType.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.RoleAliasDescription.ReadOnly =
    zio.aws.iot.model.RoleAliasDescription.wrap(buildAwsValue())
}
object RoleAliasDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.RoleAliasDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.RoleAliasDescription =
      zio.aws.iot.model.RoleAliasDescription(
        roleAlias.map(value => value),
        roleAliasArn.map(value => value),
        roleArn.map(value => value),
        owner.map(value => value),
        credentialDurationSeconds.map(value => value),
        creationDate.map(value => value),
        lastModifiedDate.map(value => value)
      )
    def roleAlias: Optional[RoleAlias]
    def roleAliasArn: Optional[RoleAliasArn]
    def roleArn: Optional[RoleArn]
    def owner: Optional[AwsAccountId]
    def credentialDurationSeconds: Optional[CredentialDurationSeconds]
    def creationDate: Optional[DateType]
    def lastModifiedDate: Optional[DateType]
    def getRoleAlias: ZIO[Any, AwsError, RoleAlias] =
      AwsError.unwrapOptionField("roleAlias", roleAlias)
    def getRoleAliasArn: ZIO[Any, AwsError, RoleAliasArn] =
      AwsError.unwrapOptionField("roleAliasArn", roleAliasArn)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getOwner: ZIO[Any, AwsError, AwsAccountId] =
      AwsError.unwrapOptionField("owner", owner)
    def getCredentialDurationSeconds
        : ZIO[Any, AwsError, CredentialDurationSeconds] = AwsError
      .unwrapOptionField("credentialDurationSeconds", credentialDurationSeconds)
    def getCreationDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("creationDate", creationDate)
    def getLastModifiedDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.RoleAliasDescription
  ) extends zio.aws.iot.model.RoleAliasDescription.ReadOnly {
    override val roleAlias: Optional[RoleAlias] = zio.aws.core.internal
      .optionalFromNullable(impl.roleAlias())
      .map(value => zio.aws.iot.model.primitives.RoleAlias(value))
    override val roleAliasArn: Optional[RoleAliasArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleAliasArn())
      .map(value => zio.aws.iot.model.primitives.RoleAliasArn(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val owner: Optional[AwsAccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.owner())
      .map(value => zio.aws.iot.model.primitives.AwsAccountId(value))
    override val credentialDurationSeconds
        : Optional[CredentialDurationSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.credentialDurationSeconds())
      .map(value =>
        zio.aws.iot.model.primitives.CredentialDurationSeconds(value)
      )
    override val creationDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.creationDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastModifiedDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.RoleAliasDescription
  ): zio.aws.iot.model.RoleAliasDescription.ReadOnly = new Wrapper(impl)
}
