package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Prefix, S3Bucket}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Destination(
    bucket: Optional[S3Bucket] = Optional.Absent,
    prefix: Optional[Prefix] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.S3Destination = {
    import S3Destination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.S3Destination
      .builder()
      .optionallyWith(
        bucket.map(value => S3Bucket.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        prefix.map(value => Prefix.unwrap(value): java.lang.String)
      )(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.S3Destination.ReadOnly =
    zio.aws.iot.model.S3Destination.wrap(buildAwsValue())
}
object S3Destination {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.S3Destination] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.S3Destination = zio.aws.iot.model
      .S3Destination(bucket.map(value => value), prefix.map(value => value))
    def bucket: Optional[S3Bucket]
    def prefix: Optional[Prefix]
    def getBucket: ZIO[Any, AwsError, S3Bucket] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getPrefix: ZIO[Any, AwsError, Prefix] =
      AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.S3Destination
  ) extends zio.aws.iot.model.S3Destination.ReadOnly {
    override val bucket: Optional[S3Bucket] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.iot.model.primitives.S3Bucket(value))
    override val prefix: Optional[Prefix] = zio.aws.core.internal
      .optionalFromNullable(impl.prefix())
      .map(value => zio.aws.iot.model.primitives.Prefix(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.S3Destination
  ): zio.aws.iot.model.S3Destination.ReadOnly = new Wrapper(impl)
}
