package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SalesforceEndpoint, SalesforceToken}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SalesforceAction(
    token: SalesforceToken,
    url: SalesforceEndpoint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SalesforceAction = {
    import SalesforceAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SalesforceAction
      .builder()
      .token(SalesforceToken.unwrap(token): java.lang.String)
      .url(SalesforceEndpoint.unwrap(url): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SalesforceAction.ReadOnly =
    zio.aws.iot.model.SalesforceAction.wrap(buildAwsValue())
}
object SalesforceAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SalesforceAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SalesforceAction =
      zio.aws.iot.model.SalesforceAction(token, url)
    def token: SalesforceToken
    def url: SalesforceEndpoint
    def getToken: ZIO[Any, Nothing, SalesforceToken] = ZIO.succeed(token)
    def getUrl: ZIO[Any, Nothing, SalesforceEndpoint] = ZIO.succeed(url)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SalesforceAction
  ) extends zio.aws.iot.model.SalesforceAction.ReadOnly {
    override val token: SalesforceToken =
      zio.aws.iot.model.primitives.SalesforceToken(impl.token())
    override val url: SalesforceEndpoint =
      zio.aws.iot.model.primitives.SalesforceEndpoint(impl.url())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SalesforceAction
  ): zio.aws.iot.model.SalesforceAction.ReadOnly = new Wrapper(impl)
}
