package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  DayOfMonth,
  ScheduledAuditArn,
  ScheduledAuditName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ScheduledAuditMetadata(
    scheduledAuditName: Optional[ScheduledAuditName] = Optional.Absent,
    scheduledAuditArn: Optional[ScheduledAuditArn] = Optional.Absent,
    frequency: Optional[zio.aws.iot.model.AuditFrequency] = Optional.Absent,
    dayOfMonth: Optional[DayOfMonth] = Optional.Absent,
    dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata = {
    import ScheduledAuditMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
      .builder()
      .optionallyWith(
        scheduledAuditName.map(value =>
          ScheduledAuditName.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditName)
      .optionallyWith(
        scheduledAuditArn.map(value =>
          ScheduledAuditArn.unwrap(value): java.lang.String
        )
      )(_.scheduledAuditArn)
      .optionallyWith(frequency.map(value => value.unwrap))(_.frequency)
      .optionallyWith(
        dayOfMonth.map(value => DayOfMonth.unwrap(value): java.lang.String)
      )(_.dayOfMonth)
      .optionallyWith(dayOfWeek.map(value => value.unwrap))(_.dayOfWeek)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly =
    zio.aws.iot.model.ScheduledAuditMetadata.wrap(buildAwsValue())
}
object ScheduledAuditMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ScheduledAuditMetadata =
      zio.aws.iot.model.ScheduledAuditMetadata(
        scheduledAuditName.map(value => value),
        scheduledAuditArn.map(value => value),
        frequency.map(value => value),
        dayOfMonth.map(value => value),
        dayOfWeek.map(value => value)
      )
    def scheduledAuditName: Optional[ScheduledAuditName]
    def scheduledAuditArn: Optional[ScheduledAuditArn]
    def frequency: Optional[zio.aws.iot.model.AuditFrequency]
    def dayOfMonth: Optional[DayOfMonth]
    def dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek]
    def getScheduledAuditName: ZIO[Any, AwsError, ScheduledAuditName] =
      AwsError.unwrapOptionField("scheduledAuditName", scheduledAuditName)
    def getScheduledAuditArn: ZIO[Any, AwsError, ScheduledAuditArn] =
      AwsError.unwrapOptionField("scheduledAuditArn", scheduledAuditArn)
    def getFrequency: ZIO[Any, AwsError, zio.aws.iot.model.AuditFrequency] =
      AwsError.unwrapOptionField("frequency", frequency)
    def getDayOfMonth: ZIO[Any, AwsError, DayOfMonth] =
      AwsError.unwrapOptionField("dayOfMonth", dayOfMonth)
    def getDayOfWeek: ZIO[Any, AwsError, zio.aws.iot.model.DayOfWeek] =
      AwsError.unwrapOptionField("dayOfWeek", dayOfWeek)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
  ) extends zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly {
    override val scheduledAuditName: Optional[ScheduledAuditName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAuditName())
        .map(value => zio.aws.iot.model.primitives.ScheduledAuditName(value))
    override val scheduledAuditArn: Optional[ScheduledAuditArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduledAuditArn())
        .map(value => zio.aws.iot.model.primitives.ScheduledAuditArn(value))
    override val frequency: Optional[zio.aws.iot.model.AuditFrequency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.frequency())
        .map(value => zio.aws.iot.model.AuditFrequency.wrap(value))
    override val dayOfMonth: Optional[DayOfMonth] = zio.aws.core.internal
      .optionalFromNullable(impl.dayOfMonth())
      .map(value => zio.aws.iot.model.primitives.DayOfMonth(value))
    override val dayOfWeek: Optional[zio.aws.iot.model.DayOfWeek] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dayOfWeek())
        .map(value => zio.aws.iot.model.DayOfWeek.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata
  ): zio.aws.iot.model.ScheduledAuditMetadata.ReadOnly = new Wrapper(impl)
}
