package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  IndexName,
  NextToken,
  QueryMaxResults,
  QueryVersion,
  QueryString
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SearchIndexRequest(
    indexName: Optional[IndexName] = Optional.Absent,
    queryString: QueryString,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[QueryMaxResults] = Optional.Absent,
    queryVersion: Optional[QueryVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SearchIndexRequest = {
    import SearchIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SearchIndexRequest
      .builder()
      .optionallyWith(
        indexName.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.indexName)
      .queryString(QueryString.unwrap(queryString): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => QueryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        queryVersion.map(value => QueryVersion.unwrap(value): java.lang.String)
      )(_.queryVersion)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SearchIndexRequest.ReadOnly =
    zio.aws.iot.model.SearchIndexRequest.wrap(buildAwsValue())
}
object SearchIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SearchIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SearchIndexRequest =
      zio.aws.iot.model.SearchIndexRequest(
        indexName.map(value => value),
        queryString,
        nextToken.map(value => value),
        maxResults.map(value => value),
        queryVersion.map(value => value)
      )
    def indexName: Optional[IndexName]
    def queryString: QueryString
    def nextToken: Optional[NextToken]
    def maxResults: Optional[QueryMaxResults]
    def queryVersion: Optional[QueryVersion]
    def getIndexName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("indexName", indexName)
    def getQueryString: ZIO[Any, Nothing, QueryString] =
      ZIO.succeed(queryString)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, QueryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getQueryVersion: ZIO[Any, AwsError, QueryVersion] =
      AwsError.unwrapOptionField("queryVersion", queryVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SearchIndexRequest
  ) extends zio.aws.iot.model.SearchIndexRequest.ReadOnly {
    override val indexName: Optional[IndexName] = zio.aws.core.internal
      .optionalFromNullable(impl.indexName())
      .map(value => zio.aws.iot.model.primitives.IndexName(value))
    override val queryString: QueryString =
      zio.aws.iot.model.primitives.QueryString(impl.queryString())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val maxResults: Optional[QueryMaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.iot.model.primitives.QueryMaxResults(value))
    override val queryVersion: Optional[QueryVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.queryVersion())
      .map(value => zio.aws.iot.model.primitives.QueryVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SearchIndexRequest
  ): zio.aws.iot.model.SearchIndexRequest.ReadOnly = new Wrapper(impl)
}
