package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SearchIndexResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    things: Optional[Iterable[zio.aws.iot.model.ThingDocument]] =
      Optional.Absent,
    thingGroups: Optional[Iterable[zio.aws.iot.model.ThingGroupDocument]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SearchIndexResponse = {
    import SearchIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SearchIndexResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        things.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.things)
      .optionallyWith(
        thingGroups.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.thingGroups)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SearchIndexResponse.ReadOnly =
    zio.aws.iot.model.SearchIndexResponse.wrap(buildAwsValue())
}
object SearchIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SearchIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SearchIndexResponse =
      zio.aws.iot.model.SearchIndexResponse(
        nextToken.map(value => value),
        things.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        thingGroups.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def things: Optional[List[zio.aws.iot.model.ThingDocument.ReadOnly]]
    def thingGroups
        : Optional[List[zio.aws.iot.model.ThingGroupDocument.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getThings
        : ZIO[Any, AwsError, List[zio.aws.iot.model.ThingDocument.ReadOnly]] =
      AwsError.unwrapOptionField("things", things)
    def getThingGroups: ZIO[Any, AwsError, List[
      zio.aws.iot.model.ThingGroupDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("thingGroups", thingGroups)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SearchIndexResponse
  ) extends zio.aws.iot.model.SearchIndexResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.iot.model.primitives.NextToken(value))
    override val things
        : Optional[List[zio.aws.iot.model.ThingDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.things())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ThingDocument.wrap(item)
          }.toList
        )
    override val thingGroups
        : Optional[List[zio.aws.iot.model.ThingGroupDocument.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.ThingGroupDocument.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SearchIndexResponse
  ): zio.aws.iot.model.SearchIndexResponse.ReadOnly = new Wrapper(impl)
}
