package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{SecurityProfileArn, SecurityProfileName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SecurityProfileIdentifier(
    name: SecurityProfileName,
    arn: SecurityProfileArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier = {
    import SecurityProfileIdentifier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier
      .builder()
      .name(SecurityProfileName.unwrap(name): java.lang.String)
      .arn(SecurityProfileArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly =
    zio.aws.iot.model.SecurityProfileIdentifier.wrap(buildAwsValue())
}
object SecurityProfileIdentifier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SecurityProfileIdentifier =
      zio.aws.iot.model.SecurityProfileIdentifier(name, arn)
    def name: SecurityProfileName
    def arn: SecurityProfileArn
    def getName: ZIO[Any, Nothing, SecurityProfileName] = ZIO.succeed(name)
    def getArn: ZIO[Any, Nothing, SecurityProfileArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier
  ) extends zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly {
    override val name: SecurityProfileName =
      zio.aws.iot.model.primitives.SecurityProfileName(impl.name())
    override val arn: SecurityProfileArn =
      zio.aws.iot.model.primitives.SecurityProfileArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SecurityProfileIdentifier
  ): zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly = new Wrapper(impl)
}
