package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SecurityProfileTargetMapping(
    securityProfileIdentifier: Optional[
      zio.aws.iot.model.SecurityProfileIdentifier
    ] = Optional.Absent,
    target: Optional[zio.aws.iot.model.SecurityProfileTarget] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping = {
    import SecurityProfileTargetMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping
      .builder()
      .optionallyWith(
        securityProfileIdentifier.map(value => value.buildAwsValue())
      )(_.securityProfileIdentifier)
      .optionallyWith(target.map(value => value.buildAwsValue()))(_.target)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly =
    zio.aws.iot.model.SecurityProfileTargetMapping.wrap(buildAwsValue())
}
object SecurityProfileTargetMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SecurityProfileTargetMapping =
      zio.aws.iot.model.SecurityProfileTargetMapping(
        securityProfileIdentifier.map(value => value.asEditable),
        target.map(value => value.asEditable)
      )
    def securityProfileIdentifier
        : Optional[zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly]
    def target: Optional[zio.aws.iot.model.SecurityProfileTarget.ReadOnly]
    def getSecurityProfileIdentifier: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly
    ] = AwsError.unwrapOptionField(
      "securityProfileIdentifier",
      securityProfileIdentifier
    )
    def getTarget
        : ZIO[Any, AwsError, zio.aws.iot.model.SecurityProfileTarget.ReadOnly] =
      AwsError.unwrapOptionField("target", target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping
  ) extends zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly {
    override val securityProfileIdentifier
        : Optional[zio.aws.iot.model.SecurityProfileIdentifier.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityProfileIdentifier())
        .map(value => zio.aws.iot.model.SecurityProfileIdentifier.wrap(value))
    override val target
        : Optional[zio.aws.iot.model.SecurityProfileTarget.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.target())
        .map(value => zio.aws.iot.model.SecurityProfileTarget.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SecurityProfileTargetMapping
  ): zio.aws.iot.model.SecurityProfileTargetMapping.ReadOnly = new Wrapper(impl)
}
