package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait ServiceType {
  def unwrap: software.amazon.awssdk.services.iot.model.ServiceType
}
object ServiceType {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ServiceType
  ): zio.aws.iot.model.ServiceType = value match {
    case software.amazon.awssdk.services.iot.model.ServiceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ServiceType.DATA =>
      val r = DATA
      r
    case software.amazon.awssdk.services.iot.model.ServiceType.CREDENTIAL_PROVIDER =>
      val r = CREDENTIAL_PROVIDER
      r
    case software.amazon.awssdk.services.iot.model.ServiceType.JOBS =>
      val r = JOBS
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ServiceType =
      software.amazon.awssdk.services.iot.model.ServiceType.UNKNOWN_TO_SDK_VERSION
  }
  case object DATA extends zio.aws.iot.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ServiceType =
      software.amazon.awssdk.services.iot.model.ServiceType.DATA
  }
  case object CREDENTIAL_PROVIDER extends zio.aws.iot.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ServiceType =
      software.amazon.awssdk.services.iot.model.ServiceType.CREDENTIAL_PROVIDER
  }
  case object JOBS extends zio.aws.iot.model.ServiceType {
    override def unwrap: software.amazon.awssdk.services.iot.model.ServiceType =
      software.amazon.awssdk.services.iot.model.ServiceType.JOBS
  }
}
