package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  CertificatePathOnDevice,
  Platform,
  CertificateArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SigningProfileParameter(
    certificateArn: Optional[CertificateArn] = Optional.Absent,
    platform: Optional[Platform] = Optional.Absent,
    certificatePathOnDevice: Optional[CertificatePathOnDevice] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.SigningProfileParameter = {
    import SigningProfileParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.SigningProfileParameter
      .builder()
      .optionallyWith(
        certificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.certificateArn)
      .optionallyWith(
        platform.map(value => Platform.unwrap(value): java.lang.String)
      )(_.platform)
      .optionallyWith(
        certificatePathOnDevice.map(value =>
          CertificatePathOnDevice.unwrap(value): java.lang.String
        )
      )(_.certificatePathOnDevice)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.SigningProfileParameter.ReadOnly =
    zio.aws.iot.model.SigningProfileParameter.wrap(buildAwsValue())
}
object SigningProfileParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.SigningProfileParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.SigningProfileParameter =
      zio.aws.iot.model.SigningProfileParameter(
        certificateArn.map(value => value),
        platform.map(value => value),
        certificatePathOnDevice.map(value => value)
      )
    def certificateArn: Optional[CertificateArn]
    def platform: Optional[Platform]
    def certificatePathOnDevice: Optional[CertificatePathOnDevice]
    def getCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField("certificateArn", certificateArn)
    def getPlatform: ZIO[Any, AwsError, Platform] =
      AwsError.unwrapOptionField("platform", platform)
    def getCertificatePathOnDevice
        : ZIO[Any, AwsError, CertificatePathOnDevice] = AwsError
      .unwrapOptionField("certificatePathOnDevice", certificatePathOnDevice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.SigningProfileParameter
  ) extends zio.aws.iot.model.SigningProfileParameter.ReadOnly {
    override val certificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
    override val platform: Optional[Platform] = zio.aws.core.internal
      .optionalFromNullable(impl.platform())
      .map(value => zio.aws.iot.model.primitives.Platform(value))
    override val certificatePathOnDevice: Optional[CertificatePathOnDevice] =
      zio.aws.core.internal
        .optionalFromNullable(impl.certificatePathOnDevice())
        .map(value =>
          zio.aws.iot.model.primitives.CertificatePathOnDevice(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.SigningProfileParameter
  ): zio.aws.iot.model.SigningProfileParameter.ReadOnly = new Wrapper(impl)
}
