package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.MitigationActionsTaskId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StartDetectMitigationActionsTaskResponse(
    taskId: Optional[MitigationActionsTaskId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse = {
    import StartDetectMitigationActionsTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse
      .builder()
      .optionallyWith(
        taskId.map(value =>
          MitigationActionsTaskId.unwrap(value): java.lang.String
        )
      )(_.taskId)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly =
    zio.aws.iot.model.StartDetectMitigationActionsTaskResponse
      .wrap(buildAwsValue())
}
object StartDetectMitigationActionsTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StartDetectMitigationActionsTaskResponse =
      zio.aws.iot.model
        .StartDetectMitigationActionsTaskResponse(taskId.map(value => value))
    def taskId: Optional[MitigationActionsTaskId]
    def getTaskId: ZIO[Any, AwsError, MitigationActionsTaskId] =
      AwsError.unwrapOptionField("taskId", taskId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse
  ) extends zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly {
    override val taskId: Optional[MitigationActionsTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskId())
        .map(value =>
          zio.aws.iot.model.primitives.MitigationActionsTaskId(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StartDetectMitigationActionsTaskResponse
  ): zio.aws.iot.model.StartDetectMitigationActionsTaskResponse.ReadOnly =
    new Wrapper(impl)
}
