package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  Variance,
  Minimum,
  Maximum,
  Average,
  Count,
  Sum,
  SumOfSquares,
  StdDeviation
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class Statistics(
    count: Optional[Count] = Optional.Absent,
    average: Optional[Average] = Optional.Absent,
    sum: Optional[Sum] = Optional.Absent,
    minimum: Optional[Minimum] = Optional.Absent,
    maximum: Optional[Maximum] = Optional.Absent,
    sumOfSquares: Optional[SumOfSquares] = Optional.Absent,
    variance: Optional[Variance] = Optional.Absent,
    stdDeviation: Optional[StdDeviation] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.Statistics = {
    import Statistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.Statistics
      .builder()
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .optionallyWith(
        average.map(value => Average.unwrap(value): java.lang.Double)
      )(_.average)
      .optionallyWith(sum.map(value => Sum.unwrap(value): java.lang.Double))(
        _.sum
      )
      .optionallyWith(
        minimum.map(value => Minimum.unwrap(value): java.lang.Double)
      )(_.minimum)
      .optionallyWith(
        maximum.map(value => Maximum.unwrap(value): java.lang.Double)
      )(_.maximum)
      .optionallyWith(
        sumOfSquares.map(value => SumOfSquares.unwrap(value): java.lang.Double)
      )(_.sumOfSquares)
      .optionallyWith(
        variance.map(value => Variance.unwrap(value): java.lang.Double)
      )(_.variance)
      .optionallyWith(
        stdDeviation.map(value => StdDeviation.unwrap(value): java.lang.Double)
      )(_.stdDeviation)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.Statistics.ReadOnly =
    zio.aws.iot.model.Statistics.wrap(buildAwsValue())
}
object Statistics {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.Statistics] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.Statistics = zio.aws.iot.model.Statistics(
      count.map(value => value),
      average.map(value => value),
      sum.map(value => value),
      minimum.map(value => value),
      maximum.map(value => value),
      sumOfSquares.map(value => value),
      variance.map(value => value),
      stdDeviation.map(value => value)
    )
    def count: Optional[Count]
    def average: Optional[Average]
    def sum: Optional[Sum]
    def minimum: Optional[Minimum]
    def maximum: Optional[Maximum]
    def sumOfSquares: Optional[SumOfSquares]
    def variance: Optional[Variance]
    def stdDeviation: Optional[StdDeviation]
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
    def getAverage: ZIO[Any, AwsError, Average] =
      AwsError.unwrapOptionField("average", average)
    def getSum: ZIO[Any, AwsError, Sum] = AwsError.unwrapOptionField("sum", sum)
    def getMinimum: ZIO[Any, AwsError, Minimum] =
      AwsError.unwrapOptionField("minimum", minimum)
    def getMaximum: ZIO[Any, AwsError, Maximum] =
      AwsError.unwrapOptionField("maximum", maximum)
    def getSumOfSquares: ZIO[Any, AwsError, SumOfSquares] =
      AwsError.unwrapOptionField("sumOfSquares", sumOfSquares)
    def getVariance: ZIO[Any, AwsError, Variance] =
      AwsError.unwrapOptionField("variance", variance)
    def getStdDeviation: ZIO[Any, AwsError, StdDeviation] =
      AwsError.unwrapOptionField("stdDeviation", stdDeviation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.Statistics
  ) extends zio.aws.iot.model.Statistics.ReadOnly {
    override val count: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.iot.model.primitives.Count(value))
    override val average: Optional[Average] = zio.aws.core.internal
      .optionalFromNullable(impl.average())
      .map(value => zio.aws.iot.model.primitives.Average(value))
    override val sum: Optional[Sum] = zio.aws.core.internal
      .optionalFromNullable(impl.sum())
      .map(value => zio.aws.iot.model.primitives.Sum(value))
    override val minimum: Optional[Minimum] = zio.aws.core.internal
      .optionalFromNullable(impl.minimum())
      .map(value => zio.aws.iot.model.primitives.Minimum(value))
    override val maximum: Optional[Maximum] = zio.aws.core.internal
      .optionalFromNullable(impl.maximum())
      .map(value => zio.aws.iot.model.primitives.Maximum(value))
    override val sumOfSquares: Optional[SumOfSquares] = zio.aws.core.internal
      .optionalFromNullable(impl.sumOfSquares())
      .map(value => zio.aws.iot.model.primitives.SumOfSquares(value))
    override val variance: Optional[Variance] = zio.aws.core.internal
      .optionalFromNullable(impl.variance())
      .map(value => zio.aws.iot.model.primitives.Variance(value))
    override val stdDeviation: Optional[StdDeviation] = zio.aws.core.internal
      .optionalFromNullable(impl.stdDeviation())
      .map(value => zio.aws.iot.model.primitives.StdDeviation(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.Statistics
  ): zio.aws.iot.model.Statistics.ReadOnly = new Wrapper(impl)
}
