package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.FileId
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StreamFile(
    fileId: Optional[FileId] = Optional.Absent,
    s3Location: Optional[zio.aws.iot.model.S3Location] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.StreamFile = {
    import StreamFile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StreamFile
      .builder()
      .optionallyWith(fileId.map(value => FileId.unwrap(value): Integer))(
        _.fileId
      )
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StreamFile.ReadOnly =
    zio.aws.iot.model.StreamFile.wrap(buildAwsValue())
}
object StreamFile {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.StreamFile] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StreamFile = zio.aws.iot.model.StreamFile(
      fileId.map(value => value),
      s3Location.map(value => value.asEditable)
    )
    def fileId: Optional[FileId]
    def s3Location: Optional[zio.aws.iot.model.S3Location.ReadOnly]
    def getFileId: ZIO[Any, AwsError, FileId] =
      AwsError.unwrapOptionField("fileId", fileId)
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.iot.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StreamFile
  ) extends zio.aws.iot.model.StreamFile.ReadOnly {
    override val fileId: Optional[FileId] = zio.aws.core.internal
      .optionalFromNullable(impl.fileId())
      .map(value => zio.aws.iot.model.primitives.FileId(value))
    override val s3Location: Optional[zio.aws.iot.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.iot.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StreamFile
  ): zio.aws.iot.model.StreamFile.ReadOnly = new Wrapper(impl)
}
