package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  RoleArn,
  DateType,
  StreamId,
  StreamArn,
  StreamVersion,
  StreamDescription
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StreamInfo(
    streamId: Optional[StreamId] = Optional.Absent,
    streamArn: Optional[StreamArn] = Optional.Absent,
    streamVersion: Optional[StreamVersion] = Optional.Absent,
    description: Optional[StreamDescription] = Optional.Absent,
    files: Optional[Iterable[zio.aws.iot.model.StreamFile]] = Optional.Absent,
    createdAt: Optional[DateType] = Optional.Absent,
    lastUpdatedAt: Optional[DateType] = Optional.Absent,
    roleArn: Optional[RoleArn] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.iot.model.StreamInfo = {
    import StreamInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.StreamInfo
      .builder()
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        streamArn.map(value => StreamArn.unwrap(value): java.lang.String)
      )(_.streamArn)
      .optionallyWith(
        streamVersion.map(value => StreamVersion.unwrap(value): Integer)
      )(_.streamVersion)
      .optionallyWith(
        description.map(value =>
          StreamDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        files.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.files)
      .optionallyWith(createdAt.map(value => DateType.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => DateType.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.StreamInfo.ReadOnly =
    zio.aws.iot.model.StreamInfo.wrap(buildAwsValue())
}
object StreamInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.StreamInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.StreamInfo = zio.aws.iot.model.StreamInfo(
      streamId.map(value => value),
      streamArn.map(value => value),
      streamVersion.map(value => value),
      description.map(value => value),
      files.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createdAt.map(value => value),
      lastUpdatedAt.map(value => value),
      roleArn.map(value => value)
    )
    def streamId: Optional[StreamId]
    def streamArn: Optional[StreamArn]
    def streamVersion: Optional[StreamVersion]
    def description: Optional[StreamDescription]
    def files: Optional[List[zio.aws.iot.model.StreamFile.ReadOnly]]
    def createdAt: Optional[DateType]
    def lastUpdatedAt: Optional[DateType]
    def roleArn: Optional[RoleArn]
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getStreamArn: ZIO[Any, AwsError, StreamArn] =
      AwsError.unwrapOptionField("streamArn", streamArn)
    def getStreamVersion: ZIO[Any, AwsError, StreamVersion] =
      AwsError.unwrapOptionField("streamVersion", streamVersion)
    def getDescription: ZIO[Any, AwsError, StreamDescription] =
      AwsError.unwrapOptionField("description", description)
    def getFiles
        : ZIO[Any, AwsError, List[zio.aws.iot.model.StreamFile.ReadOnly]] =
      AwsError.unwrapOptionField("files", files)
    def getCreatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.StreamInfo
  ) extends zio.aws.iot.model.StreamInfo.ReadOnly {
    override val streamId: Optional[StreamId] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => zio.aws.iot.model.primitives.StreamId(value))
    override val streamArn: Optional[StreamArn] = zio.aws.core.internal
      .optionalFromNullable(impl.streamArn())
      .map(value => zio.aws.iot.model.primitives.StreamArn(value))
    override val streamVersion: Optional[StreamVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.streamVersion())
      .map(value => zio.aws.iot.model.primitives.StreamVersion(value))
    override val description: Optional[StreamDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.iot.model.primitives.StreamDescription(value))
    override val files: Optional[List[zio.aws.iot.model.StreamFile.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.files())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.StreamFile.wrap(item)
          }.toList
        )
    override val createdAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val lastUpdatedAt: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.StreamInfo
  ): zio.aws.iot.model.StreamInfo.ReadOnly = new Wrapper(impl)
}
