package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ResourceArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceArn,
    tags: Iterable[zio.aws.iot.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TagResourceRequest.ReadOnly =
    zio.aws.iot.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TagResourceRequest =
      zio.aws.iot.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: ResourceArn
    def tags: List[zio.aws.iot.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.iot.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TagResourceRequest
  ) extends zio.aws.iot.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.iot.model.primitives.ResourceArn(impl.resourceArn())
    override val tags: List[zio.aws.iot.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.iot.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TagResourceRequest
  ): zio.aws.iot.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
