package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{
  TotalChecksCount,
  FailedChecksCount,
  CompliantChecksCount,
  NonCompliantChecksCount,
  CanceledChecksCount,
  InProgressChecksCount,
  WaitingForDataCollectionChecksCount
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TaskStatistics(
    totalChecks: Optional[TotalChecksCount] = Optional.Absent,
    inProgressChecks: Optional[InProgressChecksCount] = Optional.Absent,
    waitingForDataCollectionChecks: Optional[
      WaitingForDataCollectionChecksCount
    ] = Optional.Absent,
    compliantChecks: Optional[CompliantChecksCount] = Optional.Absent,
    nonCompliantChecks: Optional[NonCompliantChecksCount] = Optional.Absent,
    failedChecks: Optional[FailedChecksCount] = Optional.Absent,
    canceledChecks: Optional[CanceledChecksCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TaskStatistics = {
    import TaskStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TaskStatistics
      .builder()
      .optionallyWith(
        totalChecks.map(value => TotalChecksCount.unwrap(value): Integer)
      )(_.totalChecks)
      .optionallyWith(
        inProgressChecks.map(value =>
          InProgressChecksCount.unwrap(value): Integer
        )
      )(_.inProgressChecks)
      .optionallyWith(
        waitingForDataCollectionChecks.map(value =>
          WaitingForDataCollectionChecksCount.unwrap(value): Integer
        )
      )(_.waitingForDataCollectionChecks)
      .optionallyWith(
        compliantChecks.map(value =>
          CompliantChecksCount.unwrap(value): Integer
        )
      )(_.compliantChecks)
      .optionallyWith(
        nonCompliantChecks.map(value =>
          NonCompliantChecksCount.unwrap(value): Integer
        )
      )(_.nonCompliantChecks)
      .optionallyWith(
        failedChecks.map(value => FailedChecksCount.unwrap(value): Integer)
      )(_.failedChecks)
      .optionallyWith(
        canceledChecks.map(value => CanceledChecksCount.unwrap(value): Integer)
      )(_.canceledChecks)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TaskStatistics.ReadOnly =
    zio.aws.iot.model.TaskStatistics.wrap(buildAwsValue())
}
object TaskStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TaskStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TaskStatistics =
      zio.aws.iot.model.TaskStatistics(
        totalChecks.map(value => value),
        inProgressChecks.map(value => value),
        waitingForDataCollectionChecks.map(value => value),
        compliantChecks.map(value => value),
        nonCompliantChecks.map(value => value),
        failedChecks.map(value => value),
        canceledChecks.map(value => value)
      )
    def totalChecks: Optional[TotalChecksCount]
    def inProgressChecks: Optional[InProgressChecksCount]
    def waitingForDataCollectionChecks
        : Optional[WaitingForDataCollectionChecksCount]
    def compliantChecks: Optional[CompliantChecksCount]
    def nonCompliantChecks: Optional[NonCompliantChecksCount]
    def failedChecks: Optional[FailedChecksCount]
    def canceledChecks: Optional[CanceledChecksCount]
    def getTotalChecks: ZIO[Any, AwsError, TotalChecksCount] =
      AwsError.unwrapOptionField("totalChecks", totalChecks)
    def getInProgressChecks: ZIO[Any, AwsError, InProgressChecksCount] =
      AwsError.unwrapOptionField("inProgressChecks", inProgressChecks)
    def getWaitingForDataCollectionChecks
        : ZIO[Any, AwsError, WaitingForDataCollectionChecksCount] =
      AwsError.unwrapOptionField(
        "waitingForDataCollectionChecks",
        waitingForDataCollectionChecks
      )
    def getCompliantChecks: ZIO[Any, AwsError, CompliantChecksCount] =
      AwsError.unwrapOptionField("compliantChecks", compliantChecks)
    def getNonCompliantChecks: ZIO[Any, AwsError, NonCompliantChecksCount] =
      AwsError.unwrapOptionField("nonCompliantChecks", nonCompliantChecks)
    def getFailedChecks: ZIO[Any, AwsError, FailedChecksCount] =
      AwsError.unwrapOptionField("failedChecks", failedChecks)
    def getCanceledChecks: ZIO[Any, AwsError, CanceledChecksCount] =
      AwsError.unwrapOptionField("canceledChecks", canceledChecks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TaskStatistics
  ) extends zio.aws.iot.model.TaskStatistics.ReadOnly {
    override val totalChecks: Optional[TotalChecksCount] = zio.aws.core.internal
      .optionalFromNullable(impl.totalChecks())
      .map(value => zio.aws.iot.model.primitives.TotalChecksCount(value))
    override val inProgressChecks: Optional[InProgressChecksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.inProgressChecks())
        .map(value => zio.aws.iot.model.primitives.InProgressChecksCount(value))
    override val waitingForDataCollectionChecks
        : Optional[WaitingForDataCollectionChecksCount] = zio.aws.core.internal
      .optionalFromNullable(impl.waitingForDataCollectionChecks())
      .map(value =>
        zio.aws.iot.model.primitives.WaitingForDataCollectionChecksCount(value)
      )
    override val compliantChecks: Optional[CompliantChecksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.compliantChecks())
        .map(value => zio.aws.iot.model.primitives.CompliantChecksCount(value))
    override val nonCompliantChecks: Optional[NonCompliantChecksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nonCompliantChecks())
        .map(value =>
          zio.aws.iot.model.primitives.NonCompliantChecksCount(value)
        )
    override val failedChecks: Optional[FailedChecksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedChecks())
        .map(value => zio.aws.iot.model.primitives.FailedChecksCount(value))
    override val canceledChecks: Optional[CanceledChecksCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canceledChecks())
        .map(value => zio.aws.iot.model.primitives.CanceledChecksCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TaskStatistics
  ): zio.aws.iot.model.TaskStatistics.ReadOnly = new Wrapper(impl)
}
