package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  FailedFindingsCount,
  SkippedFindingsCount,
  TotalFindingsCount,
  SucceededFindingsCount,
  CanceledFindingsCount
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TaskStatisticsForAuditCheck(
    totalFindingsCount: Optional[TotalFindingsCount] = Optional.Absent,
    failedFindingsCount: Optional[FailedFindingsCount] = Optional.Absent,
    succeededFindingsCount: Optional[SucceededFindingsCount] = Optional.Absent,
    skippedFindingsCount: Optional[SkippedFindingsCount] = Optional.Absent,
    canceledFindingsCount: Optional[CanceledFindingsCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck = {
    import TaskStatisticsForAuditCheck.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
      .builder()
      .optionallyWith(
        totalFindingsCount.map(value =>
          TotalFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.totalFindingsCount)
      .optionallyWith(
        failedFindingsCount.map(value =>
          FailedFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.failedFindingsCount)
      .optionallyWith(
        succeededFindingsCount.map(value =>
          SucceededFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.succeededFindingsCount)
      .optionallyWith(
        skippedFindingsCount.map(value =>
          SkippedFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.skippedFindingsCount)
      .optionallyWith(
        canceledFindingsCount.map(value =>
          CanceledFindingsCount.unwrap(value): java.lang.Long
        )
      )(_.canceledFindingsCount)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly =
    zio.aws.iot.model.TaskStatisticsForAuditCheck.wrap(buildAwsValue())
}
object TaskStatisticsForAuditCheck {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TaskStatisticsForAuditCheck =
      zio.aws.iot.model.TaskStatisticsForAuditCheck(
        totalFindingsCount.map(value => value),
        failedFindingsCount.map(value => value),
        succeededFindingsCount.map(value => value),
        skippedFindingsCount.map(value => value),
        canceledFindingsCount.map(value => value)
      )
    def totalFindingsCount: Optional[TotalFindingsCount]
    def failedFindingsCount: Optional[FailedFindingsCount]
    def succeededFindingsCount: Optional[SucceededFindingsCount]
    def skippedFindingsCount: Optional[SkippedFindingsCount]
    def canceledFindingsCount: Optional[CanceledFindingsCount]
    def getTotalFindingsCount: ZIO[Any, AwsError, TotalFindingsCount] =
      AwsError.unwrapOptionField("totalFindingsCount", totalFindingsCount)
    def getFailedFindingsCount: ZIO[Any, AwsError, FailedFindingsCount] =
      AwsError.unwrapOptionField("failedFindingsCount", failedFindingsCount)
    def getSucceededFindingsCount: ZIO[Any, AwsError, SucceededFindingsCount] =
      AwsError.unwrapOptionField(
        "succeededFindingsCount",
        succeededFindingsCount
      )
    def getSkippedFindingsCount: ZIO[Any, AwsError, SkippedFindingsCount] =
      AwsError.unwrapOptionField("skippedFindingsCount", skippedFindingsCount)
    def getCanceledFindingsCount: ZIO[Any, AwsError, CanceledFindingsCount] =
      AwsError.unwrapOptionField("canceledFindingsCount", canceledFindingsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
  ) extends zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly {
    override val totalFindingsCount: Optional[TotalFindingsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.totalFindingsCount())
        .map(value => zio.aws.iot.model.primitives.TotalFindingsCount(value))
    override val failedFindingsCount: Optional[FailedFindingsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedFindingsCount())
        .map(value => zio.aws.iot.model.primitives.FailedFindingsCount(value))
    override val succeededFindingsCount: Optional[SucceededFindingsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.succeededFindingsCount())
        .map(value =>
          zio.aws.iot.model.primitives.SucceededFindingsCount(value)
        )
    override val skippedFindingsCount: Optional[SkippedFindingsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.skippedFindingsCount())
        .map(value => zio.aws.iot.model.primitives.SkippedFindingsCount(value))
    override val canceledFindingsCount: Optional[CanceledFindingsCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canceledFindingsCount())
        .map(value => zio.aws.iot.model.primitives.CanceledFindingsCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TaskStatisticsForAuditCheck
  ): zio.aws.iot.model.TaskStatisticsForAuditCheck.ReadOnly = new Wrapper(impl)
}
