package zio.aws.iot.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.MaxBuckets
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class TermsAggregation(
    maxBuckets: Optional[MaxBuckets] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TermsAggregation = {
    import TermsAggregation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TermsAggregation
      .builder()
      .optionallyWith(
        maxBuckets.map(value => MaxBuckets.unwrap(value): Integer)
      )(_.maxBuckets)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TermsAggregation.ReadOnly =
    zio.aws.iot.model.TermsAggregation.wrap(buildAwsValue())
}
object TermsAggregation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TermsAggregation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TermsAggregation =
      zio.aws.iot.model.TermsAggregation(maxBuckets.map(value => value))
    def maxBuckets: Optional[MaxBuckets]
    def getMaxBuckets: ZIO[Any, AwsError, MaxBuckets] =
      AwsError.unwrapOptionField("maxBuckets", maxBuckets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TermsAggregation
  ) extends zio.aws.iot.model.TermsAggregation.ReadOnly {
    override val maxBuckets: Optional[MaxBuckets] = zio.aws.core.internal
      .optionalFromNullable(impl.maxBuckets())
      .map(value => zio.aws.iot.model.primitives.MaxBuckets(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TermsAggregation
  ): zio.aws.iot.model.TermsAggregation.ReadOnly = new Wrapper(impl)
}
