package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  PolicyName,
  ClientId,
  CognitoIdentityPoolId,
  Principal
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TestAuthorizationRequest(
    principal: Optional[Principal] = Optional.Absent,
    cognitoIdentityPoolId: Optional[CognitoIdentityPoolId] = Optional.Absent,
    authInfos: Iterable[zio.aws.iot.model.AuthInfo],
    clientId: Optional[ClientId] = Optional.Absent,
    policyNamesToAdd: Optional[Iterable[PolicyName]] = Optional.Absent,
    policyNamesToSkip: Optional[Iterable[PolicyName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TestAuthorizationRequest = {
    import TestAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
      .builder()
      .optionallyWith(
        principal.map(value => Principal.unwrap(value): java.lang.String)
      )(_.principal)
      .optionallyWith(
        cognitoIdentityPoolId.map(value =>
          CognitoIdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.cognitoIdentityPoolId)
      .authInfos(authInfos.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientId.map(value => ClientId.unwrap(value): java.lang.String)
      )(_.clientId)
      .optionallyWith(
        policyNamesToAdd.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNamesToAdd)
      .optionallyWith(
        policyNamesToSkip.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyNamesToSkip)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TestAuthorizationRequest.ReadOnly =
    zio.aws.iot.model.TestAuthorizationRequest.wrap(buildAwsValue())
}
object TestAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TestAuthorizationRequest =
      zio.aws.iot.model.TestAuthorizationRequest(
        principal.map(value => value),
        cognitoIdentityPoolId.map(value => value),
        authInfos.map { item =>
          item.asEditable
        },
        clientId.map(value => value),
        policyNamesToAdd.map(value => value),
        policyNamesToSkip.map(value => value)
      )
    def principal: Optional[Principal]
    def cognitoIdentityPoolId: Optional[CognitoIdentityPoolId]
    def authInfos: List[zio.aws.iot.model.AuthInfo.ReadOnly]
    def clientId: Optional[ClientId]
    def policyNamesToAdd: Optional[List[PolicyName]]
    def policyNamesToSkip: Optional[List[PolicyName]]
    def getPrincipal: ZIO[Any, AwsError, Principal] =
      AwsError.unwrapOptionField("principal", principal)
    def getCognitoIdentityPoolId: ZIO[Any, AwsError, CognitoIdentityPoolId] =
      AwsError.unwrapOptionField("cognitoIdentityPoolId", cognitoIdentityPoolId)
    def getAuthInfos
        : ZIO[Any, Nothing, List[zio.aws.iot.model.AuthInfo.ReadOnly]] =
      ZIO.succeed(authInfos)
    def getClientId: ZIO[Any, AwsError, ClientId] =
      AwsError.unwrapOptionField("clientId", clientId)
    def getPolicyNamesToAdd: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("policyNamesToAdd", policyNamesToAdd)
    def getPolicyNamesToSkip: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("policyNamesToSkip", policyNamesToSkip)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
  ) extends zio.aws.iot.model.TestAuthorizationRequest.ReadOnly {
    override val principal: Optional[Principal] = zio.aws.core.internal
      .optionalFromNullable(impl.principal())
      .map(value => zio.aws.iot.model.primitives.Principal(value))
    override val cognitoIdentityPoolId: Optional[CognitoIdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cognitoIdentityPoolId())
        .map(value => zio.aws.iot.model.primitives.CognitoIdentityPoolId(value))
    override val authInfos: List[zio.aws.iot.model.AuthInfo.ReadOnly] = impl
      .authInfos()
      .asScala
      .map { item =>
        zio.aws.iot.model.AuthInfo.wrap(item)
      }
      .toList
    override val clientId: Optional[ClientId] = zio.aws.core.internal
      .optionalFromNullable(impl.clientId())
      .map(value => zio.aws.iot.model.primitives.ClientId(value))
    override val policyNamesToAdd: Optional[List[PolicyName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyNamesToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.PolicyName(item)
          }.toList
        )
    override val policyNamesToSkip: Optional[List[PolicyName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyNamesToSkip())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.primitives.PolicyName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TestAuthorizationRequest
  ): zio.aws.iot.model.TestAuthorizationRequest.ReadOnly = new Wrapper(impl)
}
