package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  ThingTypeName,
  AttributeName,
  ThingName,
  ThingArn,
  Version,
  AttributeValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThingAttribute(
    thingName: Optional[ThingName] = Optional.Absent,
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    thingArn: Optional[ThingArn] = Optional.Absent,
    attributes: Optional[Map[AttributeName, AttributeValue]] = Optional.Absent,
    version: Optional[Version] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingAttribute = {
    import ThingAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingAttribute
      .builder()
      .optionallyWith(
        thingName.map(value => ThingName.unwrap(value): java.lang.String)
      )(_.thingName)
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        thingArn.map(value => ThingArn.unwrap(value): java.lang.String)
      )(_.thingArn)
      .optionallyWith(
        attributes.map(value =>
          value
            .map({ case (key, value) =>
              (AttributeName.unwrap(key): java.lang.String) -> (AttributeValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.attributes)
      .optionallyWith(
        version.map(value => Version.unwrap(value): java.lang.Long)
      )(_.version)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingAttribute.ReadOnly =
    zio.aws.iot.model.ThingAttribute.wrap(buildAwsValue())
}
object ThingAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingAttribute =
      zio.aws.iot.model.ThingAttribute(
        thingName.map(value => value),
        thingTypeName.map(value => value),
        thingArn.map(value => value),
        attributes.map(value => value),
        version.map(value => value)
      )
    def thingName: Optional[ThingName]
    def thingTypeName: Optional[ThingTypeName]
    def thingArn: Optional[ThingArn]
    def attributes: Optional[Map[AttributeName, AttributeValue]]
    def version: Optional[Version]
    def getThingName: ZIO[Any, AwsError, ThingName] =
      AwsError.unwrapOptionField("thingName", thingName)
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getThingArn: ZIO[Any, AwsError, ThingArn] =
      AwsError.unwrapOptionField("thingArn", thingArn)
    def getAttributes: ZIO[Any, AwsError, Map[AttributeName, AttributeValue]] =
      AwsError.unwrapOptionField("attributes", attributes)
    def getVersion: ZIO[Any, AwsError, Version] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingAttribute
  ) extends zio.aws.iot.model.ThingAttribute.ReadOnly {
    override val thingName: Optional[ThingName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingName())
      .map(value => zio.aws.iot.model.primitives.ThingName(value))
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val thingArn: Optional[ThingArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingArn())
      .map(value => zio.aws.iot.model.primitives.ThingArn(value))
    override val attributes: Optional[Map[AttributeName, AttributeValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributes())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.iot.model.primitives.AttributeName(
                key
              ) -> zio.aws.iot.model.primitives.AttributeValue(value)
            })
            .toMap
        )
    override val version: Optional[Version] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => zio.aws.iot.model.primitives.Version(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingAttribute
  ): zio.aws.iot.model.ThingAttribute.ReadOnly = new Wrapper(impl)
}
