package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{DisconnectReason, ConnectivityTimestamp}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThingConnectivity(
    connected: Optional[Boolean] = Optional.Absent,
    timestamp: Optional[ConnectivityTimestamp] = Optional.Absent,
    disconnectReason: Optional[DisconnectReason] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingConnectivity = {
    import ThingConnectivity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingConnectivity
      .builder()
      .optionallyWith(connected.map(value => value: java.lang.Boolean))(
        _.connected
      )
      .optionallyWith(
        timestamp.map(value =>
          ConnectivityTimestamp.unwrap(value): java.lang.Long
        )
      )(_.timestamp)
      .optionallyWith(
        disconnectReason.map(value =>
          DisconnectReason.unwrap(value): java.lang.String
        )
      )(_.disconnectReason)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingConnectivity.ReadOnly =
    zio.aws.iot.model.ThingConnectivity.wrap(buildAwsValue())
}
object ThingConnectivity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingConnectivity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingConnectivity =
      zio.aws.iot.model.ThingConnectivity(
        connected.map(value => value),
        timestamp.map(value => value),
        disconnectReason.map(value => value)
      )
    def connected: Optional[Boolean]
    def timestamp: Optional[ConnectivityTimestamp]
    def disconnectReason: Optional[DisconnectReason]
    def getConnected: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("connected", connected)
    def getTimestamp: ZIO[Any, AwsError, ConnectivityTimestamp] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getDisconnectReason: ZIO[Any, AwsError, DisconnectReason] =
      AwsError.unwrapOptionField("disconnectReason", disconnectReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingConnectivity
  ) extends zio.aws.iot.model.ThingConnectivity.ReadOnly {
    override val connected: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.connected())
      .map(value => value: Boolean)
    override val timestamp: Optional[ConnectivityTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestamp())
        .map(value => zio.aws.iot.model.primitives.ConnectivityTimestamp(value))
    override val disconnectReason: Optional[DisconnectReason] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disconnectReason())
        .map(value => zio.aws.iot.model.primitives.DisconnectReason(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingConnectivity
  ): zio.aws.iot.model.ThingConnectivity.ReadOnly = new Wrapper(impl)
}
