package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThingGroupIndexingConfiguration(
    thingGroupIndexingMode: zio.aws.iot.model.ThingGroupIndexingMode,
    managedFields: Optional[Iterable[zio.aws.iot.model.Field]] =
      Optional.Absent,
    customFields: Optional[Iterable[zio.aws.iot.model.Field]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingGroupIndexingConfiguration = {
    import ThingGroupIndexingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingGroupIndexingConfiguration
      .builder()
      .thingGroupIndexingMode(thingGroupIndexingMode.unwrap)
      .optionallyWith(
        managedFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.managedFields)
      .optionallyWith(
        customFields.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.customFields)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly =
    zio.aws.iot.model.ThingGroupIndexingConfiguration.wrap(buildAwsValue())
}
object ThingGroupIndexingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingGroupIndexingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingGroupIndexingConfiguration =
      zio.aws.iot.model.ThingGroupIndexingConfiguration(
        thingGroupIndexingMode,
        managedFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        customFields.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def thingGroupIndexingMode: zio.aws.iot.model.ThingGroupIndexingMode
    def managedFields: Optional[List[zio.aws.iot.model.Field.ReadOnly]]
    def customFields: Optional[List[zio.aws.iot.model.Field.ReadOnly]]
    def getThingGroupIndexingMode
        : ZIO[Any, Nothing, zio.aws.iot.model.ThingGroupIndexingMode] =
      ZIO.succeed(thingGroupIndexingMode)
    def getManagedFields
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("managedFields", managedFields)
    def getCustomFields
        : ZIO[Any, AwsError, List[zio.aws.iot.model.Field.ReadOnly]] =
      AwsError.unwrapOptionField("customFields", customFields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupIndexingConfiguration
  ) extends zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly {
    override val thingGroupIndexingMode
        : zio.aws.iot.model.ThingGroupIndexingMode =
      zio.aws.iot.model.ThingGroupIndexingMode
        .wrap(impl.thingGroupIndexingMode())
    override val managedFields
        : Optional[List[zio.aws.iot.model.Field.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.managedFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Field.wrap(item)
          }.toList
        )
    override val customFields
        : Optional[List[zio.aws.iot.model.Field.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customFields())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.iot.model.Field.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupIndexingConfiguration
  ): zio.aws.iot.model.ThingGroupIndexingConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
