package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.ThingGroupDescription
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThingGroupProperties(
    thingGroupDescription: Optional[ThingGroupDescription] = Optional.Absent,
    attributePayload: Optional[zio.aws.iot.model.AttributePayload] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingGroupProperties = {
    import ThingGroupProperties.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingGroupProperties
      .builder()
      .optionallyWith(
        thingGroupDescription.map(value =>
          ThingGroupDescription.unwrap(value): java.lang.String
        )
      )(_.thingGroupDescription)
      .optionallyWith(attributePayload.map(value => value.buildAwsValue()))(
        _.attributePayload
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingGroupProperties.ReadOnly =
    zio.aws.iot.model.ThingGroupProperties.wrap(buildAwsValue())
}
object ThingGroupProperties {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingGroupProperties
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingGroupProperties =
      zio.aws.iot.model.ThingGroupProperties(
        thingGroupDescription.map(value => value),
        attributePayload.map(value => value.asEditable)
      )
    def thingGroupDescription: Optional[ThingGroupDescription]
    def attributePayload: Optional[zio.aws.iot.model.AttributePayload.ReadOnly]
    def getThingGroupDescription: ZIO[Any, AwsError, ThingGroupDescription] =
      AwsError.unwrapOptionField("thingGroupDescription", thingGroupDescription)
    def getAttributePayload
        : ZIO[Any, AwsError, zio.aws.iot.model.AttributePayload.ReadOnly] =
      AwsError.unwrapOptionField("attributePayload", attributePayload)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupProperties
  ) extends zio.aws.iot.model.ThingGroupProperties.ReadOnly {
    override val thingGroupDescription: Optional[ThingGroupDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingGroupDescription())
        .map(value => zio.aws.iot.model.primitives.ThingGroupDescription(value))
    override val attributePayload
        : Optional[zio.aws.iot.model.AttributePayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attributePayload())
        .map(value => zio.aws.iot.model.AttributePayload.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingGroupProperties
  ): zio.aws.iot.model.ThingGroupProperties.ReadOnly = new Wrapper(impl)
}
