package zio.aws.iot.model
import scala.jdk.CollectionConverters._
sealed trait ThingIndexingMode {
  def unwrap: software.amazon.awssdk.services.iot.model.ThingIndexingMode
}
object ThingIndexingMode {
  def wrap(
      value: software.amazon.awssdk.services.iot.model.ThingIndexingMode
  ): zio.aws.iot.model.ThingIndexingMode = value match {
    case software.amazon.awssdk.services.iot.model.ThingIndexingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.iot.model.ThingIndexingMode.OFF =>
      val r = OFF
      r
    case software.amazon.awssdk.services.iot.model.ThingIndexingMode.REGISTRY =>
      val r = REGISTRY
      r
    case software.amazon.awssdk.services.iot.model.ThingIndexingMode.REGISTRY_AND_SHADOW =>
      val r = REGISTRY_AND_SHADOW
      r
  }
  case object unknownToSdkVersion extends zio.aws.iot.model.ThingIndexingMode {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ThingIndexingMode =
      software.amazon.awssdk.services.iot.model.ThingIndexingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object OFF extends zio.aws.iot.model.ThingIndexingMode {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ThingIndexingMode =
      software.amazon.awssdk.services.iot.model.ThingIndexingMode.OFF
  }
  case object REGISTRY extends zio.aws.iot.model.ThingIndexingMode {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ThingIndexingMode =
      software.amazon.awssdk.services.iot.model.ThingIndexingMode.REGISTRY
  }
  case object REGISTRY_AND_SHADOW extends zio.aws.iot.model.ThingIndexingMode {
    override def unwrap
        : software.amazon.awssdk.services.iot.model.ThingIndexingMode =
      software.amazon.awssdk.services.iot.model.ThingIndexingMode.REGISTRY_AND_SHADOW
  }
}
