package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{ThingTypeArn, ThingTypeName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ThingTypeDefinition(
    thingTypeName: Optional[ThingTypeName] = Optional.Absent,
    thingTypeArn: Optional[ThingTypeArn] = Optional.Absent,
    thingTypeProperties: Optional[zio.aws.iot.model.ThingTypeProperties] =
      Optional.Absent,
    thingTypeMetadata: Optional[zio.aws.iot.model.ThingTypeMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.ThingTypeDefinition = {
    import ThingTypeDefinition.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.ThingTypeDefinition
      .builder()
      .optionallyWith(
        thingTypeName.map(value =>
          ThingTypeName.unwrap(value): java.lang.String
        )
      )(_.thingTypeName)
      .optionallyWith(
        thingTypeArn.map(value => ThingTypeArn.unwrap(value): java.lang.String)
      )(_.thingTypeArn)
      .optionallyWith(thingTypeProperties.map(value => value.buildAwsValue()))(
        _.thingTypeProperties
      )
      .optionallyWith(thingTypeMetadata.map(value => value.buildAwsValue()))(
        _.thingTypeMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.ThingTypeDefinition.ReadOnly =
    zio.aws.iot.model.ThingTypeDefinition.wrap(buildAwsValue())
}
object ThingTypeDefinition {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.ThingTypeDefinition
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.ThingTypeDefinition =
      zio.aws.iot.model.ThingTypeDefinition(
        thingTypeName.map(value => value),
        thingTypeArn.map(value => value),
        thingTypeProperties.map(value => value.asEditable),
        thingTypeMetadata.map(value => value.asEditable)
      )
    def thingTypeName: Optional[ThingTypeName]
    def thingTypeArn: Optional[ThingTypeArn]
    def thingTypeProperties
        : Optional[zio.aws.iot.model.ThingTypeProperties.ReadOnly]
    def thingTypeMetadata
        : Optional[zio.aws.iot.model.ThingTypeMetadata.ReadOnly]
    def getThingTypeName: ZIO[Any, AwsError, ThingTypeName] =
      AwsError.unwrapOptionField("thingTypeName", thingTypeName)
    def getThingTypeArn: ZIO[Any, AwsError, ThingTypeArn] =
      AwsError.unwrapOptionField("thingTypeArn", thingTypeArn)
    def getThingTypeProperties
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingTypeProperties.ReadOnly] =
      AwsError.unwrapOptionField("thingTypeProperties", thingTypeProperties)
    def getThingTypeMetadata
        : ZIO[Any, AwsError, zio.aws.iot.model.ThingTypeMetadata.ReadOnly] =
      AwsError.unwrapOptionField("thingTypeMetadata", thingTypeMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.ThingTypeDefinition
  ) extends zio.aws.iot.model.ThingTypeDefinition.ReadOnly {
    override val thingTypeName: Optional[ThingTypeName] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeName())
      .map(value => zio.aws.iot.model.primitives.ThingTypeName(value))
    override val thingTypeArn: Optional[ThingTypeArn] = zio.aws.core.internal
      .optionalFromNullable(impl.thingTypeArn())
      .map(value => zio.aws.iot.model.primitives.ThingTypeArn(value))
    override val thingTypeProperties
        : Optional[zio.aws.iot.model.ThingTypeProperties.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingTypeProperties())
        .map(value => zio.aws.iot.model.ThingTypeProperties.wrap(value))
    override val thingTypeMetadata
        : Optional[zio.aws.iot.model.ThingTypeMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thingTypeMetadata())
        .map(value => zio.aws.iot.model.ThingTypeMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.ThingTypeDefinition
  ): zio.aws.iot.model.ThingTypeDefinition.ReadOnly = new Wrapper(impl)
}
