package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.InProgressTimeoutInMinutes
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TimeoutConfig(
    inProgressTimeoutInMinutes: Optional[InProgressTimeoutInMinutes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TimeoutConfig = {
    import TimeoutConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TimeoutConfig
      .builder()
      .optionallyWith(
        inProgressTimeoutInMinutes.map(value =>
          InProgressTimeoutInMinutes.unwrap(value): java.lang.Long
        )
      )(_.inProgressTimeoutInMinutes)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TimeoutConfig.ReadOnly =
    zio.aws.iot.model.TimeoutConfig.wrap(buildAwsValue())
}
object TimeoutConfig {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.TimeoutConfig] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TimeoutConfig = zio.aws.iot.model
      .TimeoutConfig(inProgressTimeoutInMinutes.map(value => value))
    def inProgressTimeoutInMinutes: Optional[InProgressTimeoutInMinutes]
    def getInProgressTimeoutInMinutes
        : ZIO[Any, AwsError, InProgressTimeoutInMinutes] =
      AwsError.unwrapOptionField(
        "inProgressTimeoutInMinutes",
        inProgressTimeoutInMinutes
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TimeoutConfig
  ) extends zio.aws.iot.model.TimeoutConfig.ReadOnly {
    override val inProgressTimeoutInMinutes
        : Optional[InProgressTimeoutInMinutes] = zio.aws.core.internal
      .optionalFromNullable(impl.inProgressTimeoutInMinutes())
      .map(value =>
        zio.aws.iot.model.primitives.InProgressTimeoutInMinutes(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TimeoutConfig
  ): zio.aws.iot.model.TimeoutConfig.ReadOnly = new Wrapper(impl)
}
