package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  TimestreamTableName,
  TimestreamDatabaseName,
  AwsArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TimestreamAction(
    roleArn: AwsArn,
    databaseName: TimestreamDatabaseName,
    tableName: TimestreamTableName,
    dimensions: Iterable[zio.aws.iot.model.TimestreamDimension],
    timestamp: Optional[zio.aws.iot.model.TimestreamTimestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TimestreamAction = {
    import TimestreamAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TimestreamAction
      .builder()
      .roleArn(AwsArn.unwrap(roleArn): java.lang.String)
      .databaseName(
        TimestreamDatabaseName.unwrap(databaseName): java.lang.String
      )
      .tableName(TimestreamTableName.unwrap(tableName): java.lang.String)
      .dimensions(dimensions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(timestamp.map(value => value.buildAwsValue()))(
        _.timestamp
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TimestreamAction.ReadOnly =
    zio.aws.iot.model.TimestreamAction.wrap(buildAwsValue())
}
object TimestreamAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TimestreamAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TimestreamAction =
      zio.aws.iot.model.TimestreamAction(
        roleArn,
        databaseName,
        tableName,
        dimensions.map { item =>
          item.asEditable
        },
        timestamp.map(value => value.asEditable)
      )
    def roleArn: AwsArn
    def databaseName: TimestreamDatabaseName
    def tableName: TimestreamTableName
    def dimensions: List[zio.aws.iot.model.TimestreamDimension.ReadOnly]
    def timestamp: Optional[zio.aws.iot.model.TimestreamTimestamp.ReadOnly]
    def getRoleArn: ZIO[Any, Nothing, AwsArn] = ZIO.succeed(roleArn)
    def getDatabaseName: ZIO[Any, Nothing, TimestreamDatabaseName] =
      ZIO.succeed(databaseName)
    def getTableName: ZIO[Any, Nothing, TimestreamTableName] =
      ZIO.succeed(tableName)
    def getDimensions: ZIO[Any, Nothing, List[
      zio.aws.iot.model.TimestreamDimension.ReadOnly
    ]] = ZIO.succeed(dimensions)
    def getTimestamp
        : ZIO[Any, AwsError, zio.aws.iot.model.TimestreamTimestamp.ReadOnly] =
      AwsError.unwrapOptionField("timestamp", timestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TimestreamAction
  ) extends zio.aws.iot.model.TimestreamAction.ReadOnly {
    override val roleArn: AwsArn =
      zio.aws.iot.model.primitives.AwsArn(impl.roleArn())
    override val databaseName: TimestreamDatabaseName =
      zio.aws.iot.model.primitives.TimestreamDatabaseName(impl.databaseName())
    override val tableName: TimestreamTableName =
      zio.aws.iot.model.primitives.TimestreamTableName(impl.tableName())
    override val dimensions
        : List[zio.aws.iot.model.TimestreamDimension.ReadOnly] = impl
      .dimensions()
      .asScala
      .map { item =>
        zio.aws.iot.model.TimestreamDimension.wrap(item)
      }
      .toList
    override val timestamp
        : Optional[zio.aws.iot.model.TimestreamTimestamp.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timestamp())
        .map(value => zio.aws.iot.model.TimestreamTimestamp.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TimestreamAction
  ): zio.aws.iot.model.TimestreamAction.ReadOnly = new Wrapper(impl)
}
