package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  TimestreamDimensionValue,
  TimestreamDimensionName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TimestreamDimension(
    name: TimestreamDimensionName,
    value: TimestreamDimensionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TimestreamDimension = {
    import TimestreamDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TimestreamDimension
      .builder()
      .name(TimestreamDimensionName.unwrap(name): java.lang.String)
      .value(TimestreamDimensionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TimestreamDimension.ReadOnly =
    zio.aws.iot.model.TimestreamDimension.wrap(buildAwsValue())
}
object TimestreamDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TimestreamDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TimestreamDimension =
      zio.aws.iot.model.TimestreamDimension(name, value)
    def name: TimestreamDimensionName
    def value: TimestreamDimensionValue
    def getName: ZIO[Any, Nothing, TimestreamDimensionName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, TimestreamDimensionValue] =
      ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TimestreamDimension
  ) extends zio.aws.iot.model.TimestreamDimension.ReadOnly {
    override val name: TimestreamDimensionName =
      zio.aws.iot.model.primitives.TimestreamDimensionName(impl.name())
    override val value: TimestreamDimensionValue =
      zio.aws.iot.model.primitives.TimestreamDimensionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TimestreamDimension
  ): zio.aws.iot.model.TimestreamDimension.ReadOnly = new Wrapper(impl)
}
