package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  TimestreamTimestampUnit,
  TimestreamTimestampValue
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TimestreamTimestamp(
    value: TimestreamTimestampValue,
    unit: TimestreamTimestampUnit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TimestreamTimestamp = {
    import TimestreamTimestamp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TimestreamTimestamp
      .builder()
      .value(TimestreamTimestampValue.unwrap(value): java.lang.String)
      .unit(TimestreamTimestampUnit.unwrap(unit): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TimestreamTimestamp.ReadOnly =
    zio.aws.iot.model.TimestreamTimestamp.wrap(buildAwsValue())
}
object TimestreamTimestamp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TimestreamTimestamp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TimestreamTimestamp =
      zio.aws.iot.model.TimestreamTimestamp(value, unit)
    def value: TimestreamTimestampValue
    def unit: TimestreamTimestampUnit
    def getValue: ZIO[Any, Nothing, TimestreamTimestampValue] =
      ZIO.succeed(value)
    def getUnit: ZIO[Any, Nothing, TimestreamTimestampUnit] = ZIO.succeed(unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TimestreamTimestamp
  ) extends zio.aws.iot.model.TimestreamTimestamp.ReadOnly {
    override val value: TimestreamTimestampValue =
      zio.aws.iot.model.primitives.TimestreamTimestampValue(impl.value())
    override val unit: TimestreamTimestampUnit =
      zio.aws.iot.model.primitives.TimestreamTimestampUnit(impl.unit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TimestreamTimestamp
  ): zio.aws.iot.model.TimestreamTimestamp.ReadOnly = new Wrapper(impl)
}
