package zio.aws.iot.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TopicRuleDestinationConfiguration(
    httpUrlConfiguration: Optional[
      zio.aws.iot.model.HttpUrlDestinationConfiguration
    ] = Optional.Absent,
    vpcConfiguration: Optional[zio.aws.iot.model.VpcDestinationConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TopicRuleDestinationConfiguration = {
    import TopicRuleDestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRuleDestinationConfiguration
      .builder()
      .optionallyWith(httpUrlConfiguration.map(value => value.buildAwsValue()))(
        _.httpUrlConfiguration
      )
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRuleDestinationConfiguration.ReadOnly =
    zio.aws.iot.model.TopicRuleDestinationConfiguration.wrap(buildAwsValue())
}
object TopicRuleDestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TopicRuleDestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRuleDestinationConfiguration =
      zio.aws.iot.model.TopicRuleDestinationConfiguration(
        httpUrlConfiguration.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable)
      )
    def httpUrlConfiguration
        : Optional[zio.aws.iot.model.HttpUrlDestinationConfiguration.ReadOnly]
    def vpcConfiguration
        : Optional[zio.aws.iot.model.VpcDestinationConfiguration.ReadOnly]
    def getHttpUrlConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.HttpUrlDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("httpUrlConfiguration", httpUrlConfiguration)
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.iot.model.VpcDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleDestinationConfiguration
  ) extends zio.aws.iot.model.TopicRuleDestinationConfiguration.ReadOnly {
    override val httpUrlConfiguration
        : Optional[zio.aws.iot.model.HttpUrlDestinationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.httpUrlConfiguration())
        .map(value =>
          zio.aws.iot.model.HttpUrlDestinationConfiguration.wrap(value)
        )
    override val vpcConfiguration
        : Optional[zio.aws.iot.model.VpcDestinationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vpcConfiguration())
        .map(value => zio.aws.iot.model.VpcDestinationConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRuleDestinationConfiguration
  ): zio.aws.iot.model.TopicRuleDestinationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
