package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{
  AwsIotSqlVersion,
  IsDisabled,
  Description,
  SQL
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TopicRulePayload(
    sql: SQL,
    description: Optional[Description] = Optional.Absent,
    actions: Iterable[zio.aws.iot.model.Action],
    ruleDisabled: Optional[IsDisabled] = Optional.Absent,
    awsIotSqlVersion: Optional[AwsIotSqlVersion] = Optional.Absent,
    errorAction: Optional[zio.aws.iot.model.Action] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TopicRulePayload = {
    import TopicRulePayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TopicRulePayload
      .builder()
      .sql(SQL.unwrap(sql): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .actions(actions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        ruleDisabled.map(value => IsDisabled.unwrap(value): java.lang.Boolean)
      )(_.ruleDisabled)
      .optionallyWith(
        awsIotSqlVersion.map(value =>
          AwsIotSqlVersion.unwrap(value): java.lang.String
        )
      )(_.awsIotSqlVersion)
      .optionallyWith(errorAction.map(value => value.buildAwsValue()))(
        _.errorAction
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TopicRulePayload.ReadOnly =
    zio.aws.iot.model.TopicRulePayload.wrap(buildAwsValue())
}
object TopicRulePayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TopicRulePayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TopicRulePayload =
      zio.aws.iot.model.TopicRulePayload(
        sql,
        description.map(value => value),
        actions.map { item =>
          item.asEditable
        },
        ruleDisabled.map(value => value),
        awsIotSqlVersion.map(value => value),
        errorAction.map(value => value.asEditable)
      )
    def sql: SQL
    def description: Optional[Description]
    def actions: List[zio.aws.iot.model.Action.ReadOnly]
    def ruleDisabled: Optional[IsDisabled]
    def awsIotSqlVersion: Optional[AwsIotSqlVersion]
    def errorAction: Optional[zio.aws.iot.model.Action.ReadOnly]
    def getSql: ZIO[Any, Nothing, SQL] = ZIO.succeed(sql)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getActions: ZIO[Any, Nothing, List[zio.aws.iot.model.Action.ReadOnly]] =
      ZIO.succeed(actions)
    def getRuleDisabled: ZIO[Any, AwsError, IsDisabled] =
      AwsError.unwrapOptionField("ruleDisabled", ruleDisabled)
    def getAwsIotSqlVersion: ZIO[Any, AwsError, AwsIotSqlVersion] =
      AwsError.unwrapOptionField("awsIotSqlVersion", awsIotSqlVersion)
    def getErrorAction: ZIO[Any, AwsError, zio.aws.iot.model.Action.ReadOnly] =
      AwsError.unwrapOptionField("errorAction", errorAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TopicRulePayload
  ) extends zio.aws.iot.model.TopicRulePayload.ReadOnly {
    override val sql: SQL = zio.aws.iot.model.primitives.SQL(impl.sql())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.iot.model.primitives.Description(value))
    override val actions: List[zio.aws.iot.model.Action.ReadOnly] = impl
      .actions()
      .asScala
      .map { item =>
        zio.aws.iot.model.Action.wrap(item)
      }
      .toList
    override val ruleDisabled: Optional[IsDisabled] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleDisabled())
      .map(value => zio.aws.iot.model.primitives.IsDisabled(value))
    override val awsIotSqlVersion: Optional[AwsIotSqlVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsIotSqlVersion())
        .map(value => zio.aws.iot.model.primitives.AwsIotSqlVersion(value))
    override val errorAction: Optional[zio.aws.iot.model.Action.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errorAction())
        .map(value => zio.aws.iot.model.Action.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TopicRulePayload
  ): zio.aws.iot.model.TopicRulePayload.ReadOnly = new Wrapper(impl)
}
