package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{Message, AwsAccountId, CertificateId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransferCertificateRequest(
    certificateId: CertificateId,
    targetAwsAccount: AwsAccountId,
    transferMessage: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TransferCertificateRequest = {
    import TransferCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TransferCertificateRequest
      .builder()
      .certificateId(CertificateId.unwrap(certificateId): java.lang.String)
      .targetAwsAccount(AwsAccountId.unwrap(targetAwsAccount): java.lang.String)
      .optionallyWith(
        transferMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.transferMessage)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TransferCertificateRequest.ReadOnly =
    zio.aws.iot.model.TransferCertificateRequest.wrap(buildAwsValue())
}
object TransferCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TransferCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TransferCertificateRequest =
      zio.aws.iot.model.TransferCertificateRequest(
        certificateId,
        targetAwsAccount,
        transferMessage.map(value => value)
      )
    def certificateId: CertificateId
    def targetAwsAccount: AwsAccountId
    def transferMessage: Optional[Message]
    def getCertificateId: ZIO[Any, Nothing, CertificateId] =
      ZIO.succeed(certificateId)
    def getTargetAwsAccount: ZIO[Any, Nothing, AwsAccountId] =
      ZIO.succeed(targetAwsAccount)
    def getTransferMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("transferMessage", transferMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TransferCertificateRequest
  ) extends zio.aws.iot.model.TransferCertificateRequest.ReadOnly {
    override val certificateId: CertificateId =
      zio.aws.iot.model.primitives.CertificateId(impl.certificateId())
    override val targetAwsAccount: AwsAccountId =
      zio.aws.iot.model.primitives.AwsAccountId(impl.targetAwsAccount())
    override val transferMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.transferMessage())
      .map(value => zio.aws.iot.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TransferCertificateRequest
  ): zio.aws.iot.model.TransferCertificateRequest.ReadOnly = new Wrapper(impl)
}
