package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.CertificateArn
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TransferCertificateResponse(
    transferredCertificateArn: Optional[CertificateArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TransferCertificateResponse = {
    import TransferCertificateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TransferCertificateResponse
      .builder()
      .optionallyWith(
        transferredCertificateArn.map(value =>
          CertificateArn.unwrap(value): java.lang.String
        )
      )(_.transferredCertificateArn)
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TransferCertificateResponse.ReadOnly =
    zio.aws.iot.model.TransferCertificateResponse.wrap(buildAwsValue())
}
object TransferCertificateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.TransferCertificateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TransferCertificateResponse =
      zio.aws.iot.model.TransferCertificateResponse(
        transferredCertificateArn.map(value => value)
      )
    def transferredCertificateArn: Optional[CertificateArn]
    def getTransferredCertificateArn: ZIO[Any, AwsError, CertificateArn] =
      AwsError.unwrapOptionField(
        "transferredCertificateArn",
        transferredCertificateArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TransferCertificateResponse
  ) extends zio.aws.iot.model.TransferCertificateResponse.ReadOnly {
    override val transferredCertificateArn: Optional[CertificateArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.transferredCertificateArn())
        .map(value => zio.aws.iot.model.primitives.CertificateArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TransferCertificateResponse
  ): zio.aws.iot.model.TransferCertificateResponse.ReadOnly = new Wrapper(impl)
}
