package zio.aws.iot.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.iot.model.primitives.{DateType, Message}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class TransferData(
    transferMessage: Optional[Message] = Optional.Absent,
    rejectReason: Optional[Message] = Optional.Absent,
    transferDate: Optional[DateType] = Optional.Absent,
    acceptDate: Optional[DateType] = Optional.Absent,
    rejectDate: Optional[DateType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.TransferData = {
    import TransferData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.TransferData
      .builder()
      .optionallyWith(
        transferMessage.map(value => Message.unwrap(value): java.lang.String)
      )(_.transferMessage)
      .optionallyWith(
        rejectReason.map(value => Message.unwrap(value): java.lang.String)
      )(_.rejectReason)
      .optionallyWith(
        transferDate.map(value => DateType.unwrap(value): Instant)
      )(_.transferDate)
      .optionallyWith(acceptDate.map(value => DateType.unwrap(value): Instant))(
        _.acceptDate
      )
      .optionallyWith(rejectDate.map(value => DateType.unwrap(value): Instant))(
        _.rejectDate
      )
      .build()
  }
  def asReadOnly: zio.aws.iot.model.TransferData.ReadOnly =
    zio.aws.iot.model.TransferData.wrap(buildAwsValue())
}
object TransferData {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.iot.model.TransferData] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.TransferData =
      zio.aws.iot.model.TransferData(
        transferMessage.map(value => value),
        rejectReason.map(value => value),
        transferDate.map(value => value),
        acceptDate.map(value => value),
        rejectDate.map(value => value)
      )
    def transferMessage: Optional[Message]
    def rejectReason: Optional[Message]
    def transferDate: Optional[DateType]
    def acceptDate: Optional[DateType]
    def rejectDate: Optional[DateType]
    def getTransferMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("transferMessage", transferMessage)
    def getRejectReason: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("rejectReason", rejectReason)
    def getTransferDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("transferDate", transferDate)
    def getAcceptDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("acceptDate", acceptDate)
    def getRejectDate: ZIO[Any, AwsError, DateType] =
      AwsError.unwrapOptionField("rejectDate", rejectDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.TransferData
  ) extends zio.aws.iot.model.TransferData.ReadOnly {
    override val transferMessage: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.transferMessage())
      .map(value => zio.aws.iot.model.primitives.Message(value))
    override val rejectReason: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.rejectReason())
      .map(value => zio.aws.iot.model.primitives.Message(value))
    override val transferDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.transferDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val acceptDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.acceptDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
    override val rejectDate: Optional[DateType] = zio.aws.core.internal
      .optionalFromNullable(impl.rejectDate())
      .map(value => zio.aws.iot.model.primitives.DateType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.TransferData
  ): zio.aws.iot.model.TransferData.ReadOnly = new Wrapper(impl)
}
