package zio.aws.iot.model
import zio.ZIO
import zio.aws.iot.model.primitives.{AuditCheckName, RoleArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateAccountAuditConfigurationRequest(
    roleArn: Optional[RoleArn] = Optional.Absent,
    auditNotificationTargetConfigurations: Optional[Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget
    ]] = Optional.Absent,
    auditCheckConfigurations: Optional[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest = {
    import UpdateAccountAuditConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest
      .builder()
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        auditNotificationTargetConfigurations.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.auditNotificationTargetConfigurationsWithStrings)
      .optionallyWith(
        auditCheckConfigurations.map(value =>
          value
            .map({ case (key, value) =>
              (AuditCheckName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.auditCheckConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.iot.model.UpdateAccountAuditConfigurationRequest.ReadOnly =
    zio.aws.iot.model.UpdateAccountAuditConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateAccountAuditConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.iot.model.UpdateAccountAuditConfigurationRequest =
      zio.aws.iot.model.UpdateAccountAuditConfigurationRequest(
        roleArn.map(value => value),
        auditNotificationTargetConfigurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        auditCheckConfigurations.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def roleArn: Optional[RoleArn]
    def auditNotificationTargetConfigurations: Optional[Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget.ReadOnly
    ]]
    def auditCheckConfigurations: Optional[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckConfiguration.ReadOnly]
    ]
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getAuditNotificationTargetConfigurations: ZIO[Any, AwsError, Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "auditNotificationTargetConfigurations",
      auditNotificationTargetConfigurations
    )
    def getAuditCheckConfigurations: ZIO[Any, AwsError, Map[
      AuditCheckName,
      zio.aws.iot.model.AuditCheckConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "auditCheckConfigurations",
      auditCheckConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest
  ) extends zio.aws.iot.model.UpdateAccountAuditConfigurationRequest.ReadOnly {
    override val roleArn: Optional[RoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.iot.model.primitives.RoleArn(value))
    override val auditNotificationTargetConfigurations: Optional[Map[
      zio.aws.iot.model.AuditNotificationType,
      zio.aws.iot.model.AuditNotificationTarget.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.auditNotificationTargetConfigurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.AuditNotificationType.wrap(
              key
            ) -> zio.aws.iot.model.AuditNotificationTarget.wrap(value)
          })
          .toMap
      )
    override val auditCheckConfigurations: Optional[
      Map[AuditCheckName, zio.aws.iot.model.AuditCheckConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.auditCheckConfigurations())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.iot.model.primitives.AuditCheckName(
              key
            ) -> zio.aws.iot.model.AuditCheckConfiguration.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.iot.model.UpdateAccountAuditConfigurationRequest
  ): zio.aws.iot.model.UpdateAccountAuditConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
